/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.universe.LocaleFactory;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.Locale;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

public class SimpleUniverse
extends VirtualUniverse {
    protected Locale locale;
    protected Viewer[] viewer = null;

    public SimpleUniverse() {
        this(null, 1, null, null);
    }

    public SimpleUniverse(int n) {
        this(null, n, null, null);
    }

    public SimpleUniverse(Canvas3D canvas3D) {
        this(null, 1, canvas3D, null);
    }

    public SimpleUniverse(Canvas3D canvas3D, int n) {
        this(null, n, canvas3D, null);
    }

    public SimpleUniverse(HiResCoord hiResCoord, int n, Canvas3D canvas3D, URL uRL) {
        this(hiResCoord, n, canvas3D, uRL, null);
    }

    public SimpleUniverse(HiResCoord hiResCoord, int n, Canvas3D canvas3D, URL uRL, LocaleFactory localeFactory) {
        this.createLocale(hiResCoord, localeFactory);
        ViewingPlatform viewingPlatform = new ViewingPlatform(n);
        viewingPlatform.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = new Viewer(canvas3D);
        this.viewer[0].setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph((BranchGroup)viewingPlatform);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        this(viewingPlatform, viewer, null);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer, LocaleFactory localeFactory) {
        this.createLocale(null, localeFactory);
        viewingPlatform.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = viewer;
        this.viewer[0].setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph((BranchGroup)viewingPlatform);
    }

    SimpleUniverse(HiResCoord hiResCoord, LocaleFactory localeFactory) {
        this.createLocale(hiResCoord, localeFactory);
    }

    private void createLocale(HiResCoord hiResCoord, LocaleFactory localeFactory) {
        this.locale = localeFactory != null ? (hiResCoord != null ? localeFactory.createLocale(this, hiResCoord) : localeFactory.createLocale(this)) : (hiResCoord != null ? new Locale((VirtualUniverse)this, hiResCoord) : new Locale((VirtualUniverse)this));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Viewer getViewer() {
        return this.viewer[0];
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewer[0].getViewingPlatform();
    }

    public Canvas3D getCanvas() {
        return this.getCanvas(0);
    }

    public Canvas3D getCanvas(int n) {
        return this.viewer[0].getCanvas3D(n);
    }

    public void addBranchGraph(BranchGroup branchGroup) {
        this.locale.addBranchGraph(branchGroup);
    }

    public static GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (string != null) {
            if (string.equals("REQUIRED")) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if (string.equals("PREFERRED")) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
    }

    public void cleanup() {
        View view = this.viewer[0].getView();
        for (int i = view.numCanvas3Ds() - 1; i >= 0; --i) {
            Canvas3D canvas3D = view.getCanvas3D(i);
            if (!canvas3D.isOffScreen()) continue;
            canvas3D.setOffScreenBuffer(null);
        }
        view.removeAllCanvas3Ds();
        this.viewer[0].setViewingPlatform(null);
        this.removeAllLocales();
        Viewer.clearViewerMap();
        Primitive.clearGeometryCache();
    }
}

