/*
 * @(#)LoginSessionListenerTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.listener;

import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.listener.LoginSessionListener;

import javax.servlet.http.HttpSessionEvent;


import org.apache.cactus.ServletTestCase;

/**
 * LoginSessionListener NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/11 17:10:02 $
 */
public class LoginSessionListenerTest extends ServletTestCase {

	private String userId = "testuser";

	/**
	 * @param arg0
	 */
	public LoginSessionListenerTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.listener.LoginSessionListener#LoginSessionListener()} ̂߂̃eXgE\bhB
	 */
	public final void testLoginSessionListener() {
		try {
			new LoginSessionListener();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.listener.LoginSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)} ̂߂̃eXgE\bhB
	 */
	public final void testSessionCreated() {
		try {
			HttpSessionEvent event = new HttpSessionEvent(session);
			LoginSessionListener listener = new LoginSessionListener();
			listener.sessionCreated(event);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.listener.LoginSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)} ̂߂̃eXgE\bhB
	 */
	public final void testSessionDestroyed() {
		try {
			session.setAttribute(SSOServletConfig.getSessionLoginKey(), userId);
			LoginManager.getInstance().add(userId, session.getId());

			HttpSessionEvent event = new HttpSessionEvent(session);
			LoginSessionListener listener = new LoginSessionListener();
			listener.sessionDestroyed(event);

			assertTrue(!LoginManager.getInstance().isLoggedIn(userId));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
