/*
 * @(#)SSOServletConfigTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.helper;

import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.helper.SessionAuthenticator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import junit.framework.TestCase;

/**
 * SSOServletConfig NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 14:33:54 $
 */
public class SSOServletConfigTest extends TestCase {

	/**
	 * @param arg0
	 */
	public SSOServletConfigTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#isAuthRequired(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testIsAuthRequired() {
		try {
			// truȅꍇ
			String kind = "1"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.isAuthRequired(kind));

			// falsȅꍇ
			kind = "2"; // ݒt@C̓eɍ킹邱
			assertTrue(!SSOServletConfig.isAuthRequired(kind));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getAuthClassName(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testGetAuthClassName() {
		try {
			String kind = "1"; // ݒt@C̓eɍ킹邱
			String expected = "info.dragonlady.sso.servlet.helper.SessionAuthenticator";
			assertTrue(SSOServletConfig.getAuthClassName(kind).equals(expected));

			// ݒȂ̏ꍇ
			kind = "2"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.getAuthClassName(kind).equals(""));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getAttributesClassName(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testGetAttributesClassName() {
		try {
			String kind = "1"; // ݒt@C̓eɍ킹邱
			String expected = "info.dragonlady.sso.servlet.helper.SessionAttributeGenerator";
			assertTrue(SSOServletConfig.getAttributesClassName(kind).equals(expected));

			kind = "2"; // ݒt@C̓eɍ킹邱
			expected = "info.dragonlady.sso.servlet.helper.SessionAttributeGenerator";
			assertTrue(SSOServletConfig.getAttributesClassName(kind).equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getRequestParamLoginKey()} ̂߂̃eXgE\bhB
	 */
	public final void testGetRequestParamLoginKey() {
		try {
			String expected = "accountid"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.getRequestParamLoginKey().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getSessionLoginKey()} ̂߂̃eXgE\bhB
	 */
	public final void testGetSessionLoginKey() {
		try {
			String expected = "ATTRIBUTE_WRAPPER_SESSION_ACCOUNT_ID"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.getSessionLoginKey().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getSessionAttributeKeys()} ̂߂̃eXgE\bhB
	 */
	public final void testGetSessionAttributeKeys() {
		try {
			// ݒt@C̓eɍ킹邱
			Map expected = new HashMap();
			expected.put("termid", "ATTRIBUTE_WRAPPER_SESSION_TERM_ID");
			expected.put("parent", "ATTRIBUTE_WRAPPER_SESSION_PARENT_ATTRIBUTE");
			expected.put("prepaidcardid", "ATTRIBUTE_WRAPPER_SESSION_PREPAID_CARD_ID");

			Map result = SSOServletConfig.getSessionAttributeKeys();
			// 
			assertTrue(expected.entrySet().size() == result.entrySet().size());
			Iterator itr = expected.keySet().iterator();
			while(itr.hasNext()) {
				String key = (String)itr.next();
				Object value = expected.get(key);
				assertTrue(result.containsKey(key));
				assertTrue(result.get(key).equals(value));
			}
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getRedirection()} ̂߂̃eXgE\bhB
	 */
	public final void testGetRedirection() {
		try {
			String expected = "/login.html"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.getRedirection().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SSOServletConfig#getCooperationService()} ̂߂̃eXgE\bhB
	 */
	public final void testGetCooperationService() {
		try {
			String expected = "http://auth-hostname:8080/co-srv/soap/Cooperation"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOServletConfig.getCooperationService().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
