/*
 * @(#)AuthenticationExceptionTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.helper;

import info.dragonlady.sso.helper.AuthenticationException;
import junit.framework.TestCase;

/**
 * AuthenticationException NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 13:06:12 $
 */
public class AuthenticationExceptionTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AuthenticationExceptionTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.helper.AuthenticationException#AuthenticationException()} ̂߂̃eXgE\bhB
	 */
	public final void testAuthenticationException() {
		try {
			new AuthenticationException();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.AuthenticationException#AuthenticationException(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthenticationExceptionString() {
		try {
			String message = "message";
			new AuthenticationException(message);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.AuthenticationException#AuthenticationException(java.lang.Throwable)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthenticationExceptionThrowable() {
		try {
			Exception e = new Exception("exception_message");
			new AuthenticationException(e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.AuthenticationException#AuthenticationException(java.lang.String, java.lang.Throwable)} ̂߂̃eXgE\bhB
	 */
	public final void testAuthenticationExceptionStringThrowable() {
		try {
			String message = "message";
			Exception e = new Exception("exception_message");
			new AuthenticationException(message, e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
