/*
 * @(#)ArtifactReceiverServlet.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import info.dragonlady.sso.ArtifactReceiver;
import info.dragonlady.sso.SSOException;

/**
 * A[eBt@NgMT[ubgB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/10/19 17:39:32 $
 */
public class ArtifactReceiverServlet extends HttpServlet {

	/**
	 * RXgN^B
	 */
	public ArtifactReceiverServlet() {
		super();
	}

	/**
	 * A[eBt@NgMB
	 * 
	 * @param request HTTPvIuWFNg
	 * @param response HTTPIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			ArtifactReceiver receiver = new ArtifactReceiver(request, response);
			// Mvp[^̃A[eBt@NgSAMLvɊ܂߂đMAΉAT[V擾
			receiver.receive(null);
			// AT[V璊oFIDAɁAړITCgւ̓]邩mF
			String authId = receiver.getAuthId();
			Map attributes = receiver.getAttributes();

			// 擾FIDȂ̑OCZbVɊi[
			HttpSession session = request.getSession();
			session.setAttribute(SSOServletConfig.getSessionLoginKey(), authId);
			Iterator itr = attributes.keySet().iterator();
			while(itr.hasNext()) {
				Object key = itr.next();
				session.setAttribute((String)key, attributes.get(key));
			}
			// OCǗɔFIDǉ
			LoginManager.getInstance().add(authId, session.getId());
			// U̃OC񋤗L
			if(!SSOServletConfig.isClusterStandalone()) {
				UserServiceWrapper.add(authId, session.getId());
			}

			// ړITCgփ_CNg
			receiver.redirectToTarget();
		} catch(SSOException e) {
			processException(e, response, HttpServletResponse.SC_FORBIDDEN);
		} catch(Exception e) {
			processException(e, response, HttpServletResponse.SC_NOT_FOUND);
		}
	}

	private void processException(Exception e, HttpServletResponse response, int statusCode) throws ServletException {
		try {
			e.printStackTrace();
			if(!response.isCommitted()) {
				String redirectionUrl = SSOServletConfig.getRedirection();
				if(redirectionUrl != null && redirectionUrl.length() > 0) {
					response.sendRedirect(redirectionUrl);
				} else {
					response.sendError(statusCode);
				}
			}
		} catch(Exception ex) {
			throw new ServletException(ex);
		}
	}

}
