/*
 * @(#)SSOServletConfig.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.helper;

import java.util.HashMap;
import java.util.Map;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import info.dragonlady.cluster.Friend;
import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;

/**
 * SSOT[ubgp̐ݒ擾NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/21 20:42:40 $
 */
public class SSOServletConfig {

	/**
	 * \[XpXB
	 */
	private static final String resourcePath = "resources/sso_lib_config.xml";

	/**
	 * F؏Kvǂ_lŕԂB
	 * 
	 * @param kind ݒ
	 * @return boolean trueFF؏Kv^falseFF؏sv
	 * @throws ResourceParseException
	 */
	public static final boolean isAuthRequired(String kind) throws ResourceParseException {
		String expression = "sso_lib/auth-settings/auth[@kind='"+kind+"']/@auth-required";
		return Boolean.valueOf(ResourceUtils.getString(SSOServletConfig.resourcePath, expression)).booleanValue();
	}

	/**
	 * F؏NX擾B
	 * 
	 * @param kind ݒ
	 * @return String F؏NX
	 * @throws ResourceParseException
	 */
	public static final String getAuthClassName(String kind) throws ResourceParseException {
		String expression = "sso_lib/auth-settings/auth[@kind='"+kind+"']/@auth-class";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * AT[V}bvNX擾B
	 * 
	 * @param kind ݒ
	 * @return String AT[V}bvNX
	 * @throws ResourceParseException
	 */
	public static final String getAttributesClassName(String kind) throws ResourceParseException {
		String expression = "sso_lib/auth-settings/auth[@kind='"+kind+"']/@attr-class";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * vp[^̔FID̃L[擾B
	 * 
	 * @return String vp[^̔FID̃L[
	 * @throws ResourceParseException
	 */
	public static final String getRequestParamLoginKey() throws ResourceParseException {
		String expression = "sso_lib/session-attributes/login-key/@request-param";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * ZbVɐݒ肷FID̃L[擾B
	 * 
	 * @return String ZbVɐݒ肷FID̃L[
	 * @throws ResourceParseException
	 */
	public static final String getSessionLoginKey() throws ResourceParseException {
		String expression = "sso_lib/session-attributes/login-key";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * vp[^ƃZbVL[̃}bsO擾B
	 * 
	 * @return Map keyFvp[^AvalueFZbVL[
	 * @throws ResourceParseException
	 */
	public static final Map getSessionAttributeKeys() throws ResourceParseException {
		String expression = "sso_lib/session-attributes/key";
		NodeList nodeList = ResourceUtils.getNodeSet(SSOServletConfig.resourcePath, expression);
		Map map = new HashMap();
		for(int i = 0; i < nodeList.getLength(); i++) {
			Node node = nodeList.item(i);
			String requestParam = node.getAttributes().getNamedItem("request-param").getNodeValue();
			map.put(requestParam, ResourceUtils.getTextContent(node));
		}
		return map;
	}

	/**
	 * G[̃_CNV擾B
	 * 
	 * @return String _CNV
	 * @throws ResourceParseException
	 */
	public static final String getRedirection() throws ResourceParseException {
		String expression = "sso_lib/redirection";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * T[oAgT[rXAhX擾B
	 * 
	 * @return String _CNV
	 * @throws ResourceParseException
	 */
	public static final String getCooperationService() throws ResourceParseException {
		String expression = "sso_lib/cooperation-service";
		return ResourceUtils.getString(SSOServletConfig.resourcePath, expression);
	}

	/**
	 * X^hAœ삷邩ۂiNX^OsۂjB
	 * 
	 * @return boolean trueFX^hAiNX^OsȂj^falseFX^hAłȂiNX^Osj
	 * @throws ResourceParseException
	 */
	public static final boolean isClusterStandalone() throws ResourceParseException {
		String expression = "sso_lib/cluster/@standalone";
		return Boolean.valueOf(ResourceUtils.getString(SSOServletConfig.resourcePath, expression)).booleanValue();
	}

	/**
	 * NX^OT[oIPAhX擾B
	 * 
	 * @return String NX^OT[oIPAhX
	 * @throws ResourceParseException
	 */
	public static final Friend[] getFriends() throws ResourceParseException {
		String expression = "sso_lib/cluster/friends_ip";
		NodeList list = ResourceUtils.getNodeSet(SSOServletConfig.resourcePath, expression);
		Friend[] friends = new Friend[list.getLength()];
		for(int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			NamedNodeMap paramMap = node.getAttributes();
			String host = paramMap.getNamedItem("host").getNodeValue();
			String port = paramMap.getNamedItem("port").getNodeValue();
			Friend friend = new Friend();
			friend.setHost(host);
			friend.setPort(port);
			friends[i] = friend;
		}
		return friends;
	}

	/**
	 * RMIT[rX擾B
	 * 
	 * @param ipAddress IPAhX
	 * @param port |[gԍ
	 * @param serviceName T[rX
	 * @return String [UǗT[rX
	 */
	public static final String getServiceName(String ipAddress, String port, String serviceName) {
		StringBuffer name = new StringBuffer();
		name.append("//");
		name.append(ipAddress);
		name.append(":");
		name.append(port);
		name.append("/");
		name.append(serviceName);
		return name.toString();
	}

}
