/*
 * @(#)CooperationAuthenticator.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.helper;

import javax.servlet.http.HttpServletRequest;

import info.dragonlady.sso.ArtifactReceiver;
import info.dragonlady.system.service.CooperationClient;

/**
 * T[oƂ̘AgT[rXgpF؃NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/01 14:24:42 $
 */
public class CooperationAuthenticator implements Authenticator {

	/**
	 * RXgN^B
	 */
	public CooperationAuthenticator() {
	}

	/**
	 * AJEgF؏B
	 * AgT[oɖ₢킹AOC̃T[oA[eBt@Ng擾AVOTCIF؂sB
	 * A[eBt@Ng擾łȂ΁AF؂ƂB
	 * 
	 * @param request HTTPvIuWFNg
	 * @return boolean F، trueFFOK^falseFFNG
	 * @throws AuthenticationException
	 * @see info.dragonlady.sso.helper.Authenticator#authenticate(javax.servlet.http.HttpServletRequest)
	 */
	public boolean authenticate(HttpServletRequest request) throws AuthenticationException {
		try {
			String id = request.getParameter(SSOServletConfig.getRequestParamLoginKey());
			boolean result = LoginManager.getInstance().isLoggedIn(id);

			if(!result) {
				String serviceAddress = SSOServletConfig.getCooperationService();
				CooperationClient cc = new CooperationClient(serviceAddress);
				String artifact = cc.getArtifact(id);

				if(artifact != null && artifact.length() > 0) {
					// F؏
					ArtifactReceiver receiver = new ArtifactReceiver(request, null);
					receiver.receive(artifact);
					if(id.equals(receiver.getAuthId())) {
						// FOK
						LoginManager.getInstance().add(id, request.getSession().getId());
						result = true;
					}
				}
			}

			return result;
		} catch(Exception e) {
			throw new AuthenticationException(e);
		}
	}

}
