/*
 * @(#)UserServiceWrapper.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.message.SSOMessageResource;

import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;

/**
 * [UǗT[rXNCAgbp[B
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.7 $ $Date: 2006/06/12 13:27:57 $
 */
public class UserServiceWrapper {

	/**
	 * RXgN^B
	 */
	public UserServiceWrapper() {
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗɎw胆[UǉB
	 * 
	 * @param user [U
	 * @param relationId [UƕRÂID
	 * @throws UserServiceException
	 */
	public static final void add(String user, String relationId) throws UserServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[oɃ[Uǉ
					String name = SSOServletConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					service.add(user, relationId);
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗ񂩂w胆[U폜B
	 * 
	 * @param user [U
	 * @throws UserServiceException
	 */
	public static final void remove(String user) throws UserServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[U폜
					String name = SSOServletConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					service.remove(user);
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗ񂩂w胆[U폜B
	 * 
	 * @param relationId [UɕRÂID
	 * @throws UserServiceException
	 */
	public static final void removeByRelationId(String relationId) throws UserServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[U폜
					String name = SSOServletConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					service.removeByRelationId(relationId);
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[õ[UNX^OT[õ[UƓB
	 * 
	 * @throws UserServiceException
	 */
	public static final void synchronize() throws UserServiceException {
		try {
			Friend[] friends = SSOServletConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[Uꗗ擾
					String name = SSOServletConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					Map map = service.get();
					if(map != null) {
						// [JT[oɈꗗݒ
						LoginManager lm = LoginManager.getInstance();
						lm.setMap(map);
						break;
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					String message = SSOMessageResource.getMessage("", args);
					System.out.println(message);
					e.printStackTrace();
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new UserServiceException(message, e);
		}
	}

}
