/*
 * @(#)AssertionServiceImpl.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.message.SSOMessageResource;

/**
 * AT[VpT[rXC^[tF[XNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.4 $ $Date: 2006/06/12 13:27:57 $
 */
public class AssertionServiceImpl extends UnicastRemoteObject implements AssertionService {

	/**
	 * RXgN^B
	 * 
	 * @throws RemoteException
	 */
	public AssertionServiceImpl() throws RemoteException {
		super();
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @throws RemoteException
	 */
	public AssertionServiceImpl(int port) throws RemoteException {
		super(port);
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @param csf [gIuWFNǧĂяoɎgpANCAg\Pbgt@Ng
	 * @param ssf [gIuWFNgĂяoMAT[o\Pbgt@Ng
	 * @throws RemoteException
	 */
	public AssertionServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
		super(port, csf, ssf);
	}

	/**
	 * wIDAAT[VnhAAT[Ṽ}bsOݒB
	 * 
	 * @param id ID
	 * @param handle AT[Vnh
	 * @param assertion AT[V
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#put(java.lang.String, java.lang.String, java.lang.String)
	 */
	public synchronized void put(String id, String handle, String assertion) throws RemoteException {
		try {
			AssertionManager am = AssertionManager.getInstance();
			am.getHandleMap().put(id, handle);
			am.getAssertionMap().put(handle, assertion);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * wnhL[ƂAT[VAAT[Vnh̃}bsO폜B
	 * 
	 * @param handle AT[Vnh
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#removeByHandle(byte[])
	 */
	public synchronized void removeByHandle(byte[] handle) throws RemoteException {
		try {
			AssertionManager.getInstance().removeByHandle(handle);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * wIDL[ƂAT[VAAT[Vnh̃}bsO폜B
	 * 
	 * @param id ID
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#removeById(java.lang.String)
	 */
	public synchronized void removeById(String id) throws RemoteException {
		try {
			AssertionManager.getInstance().removeById(id);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[V}bv擾B
	 * 
	 * @return Map AT[V}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#getAssertionMap()
	 */
	public synchronized Map getAssertionMap() throws RemoteException {
		try {
			Map map = AssertionManager.getInstance().getAssertionMap();
			return map;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[Vnh}bv擾B
	 * 
	 * @return Map AT[Vnh}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#getHandleMap()
	 */
	public synchronized Map getHandleMap() throws RemoteException {
		try {
			Map map = AssertionManager.getInstance().getHandleMap();
			return map;
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[V}bvݒB
	 * 
	 * @param assertionMap AT[V}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#setAssertionMap(java.util.Map)
	 */
	public synchronized void setAssertionMap(Map assertionMap) throws RemoteException {
		try {
			AssertionManager.getInstance().setAssertionMap(assertionMap);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[Vnh}bvݒB
	 * 
	 * @param handleMap AT[Vnh}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#setHandleMap(java.util.Map)
	 */
	public synchronized void setHandleMap(Map handleMap) throws RemoteException {
		try {
			AssertionManager.getInstance().setHandleMap(handleMap);
		} catch(Exception e) {
			e.printStackTrace();
			String message = SSOMessageResource.getMessage("");
			throw new RemoteException(message, e);
		}
	}

}
