/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.util;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.util.ResourceParseException;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;
import org.opensaml.artifact.Util;

public class AssertionGenerator {
    public static final Artifact generateAssertion(String id, String authId, Map attributes) throws ResourceParseException, SAMLException, NoSuchAlgorithmException {
        SAMLAssertion assertion = new SAMLAssertion();
        assertion.setIssuer(SSOConfig.getIssuer());
        Calendar calendar = Calendar.getInstance();
        assertion.setNotBefore(calendar.getTime());
        calendar.add(13, SSOConfig.getAssertionLife());
        assertion.setNotOnOrAfter(calendar.getTime());
        SAMLNameIdentifier identifier = new SAMLNameIdentifier();
        identifier.setName(authId);
        SAMLSubject subject = new SAMLSubject();
        subject.setNameIdentifier(identifier);
        subject.addConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:artifact");
        SAMLAuthenticationStatement authStatement = new SAMLAuthenticationStatement();
        authStatement.setAuthInstant(Calendar.getInstance().getTime());
        authStatement.setAuthMethod("urn:oasis:names:tc:SAML:1.0:am:password");
        authStatement.setSubject(subject);
        assertion.addStatement((SAMLStatement)authStatement);
        SAMLNameIdentifier identifier2 = new SAMLNameIdentifier();
        identifier2.setName(authId);
        SAMLSubject attrSubject = new SAMLSubject();
        attrSubject.setNameIdentifier(identifier2);
        SAMLAttributeStatement attrStatement = new SAMLAttributeStatement();
        attrStatement.setSubject(attrSubject);
        List attributeList = SSOConfig.getSAMLAttributeList();
        int i = 0;
        while (i < attributeList.size()) {
            SAMLAttribute attribute = new SAMLAttribute();
            String attrName = (String)attributeList.get(i);
            attribute.setName(attrName);
            attribute.setNamespace(SSOConfig.getProvider());
            attribute.addValue(attributes != null ? attributes.get(attrName) : null);
            attrStatement.addAttribute(attribute);
            ++i;
        }
        assertion.addStatement((SAMLStatement)attrStatement);
        byte[] handle = AssertionManager.getInstance().add(assertion, id);
        SAMLArtifactType0001 artifact = null;
        byte[] srcId = Util.generateSourceId((String)SSOConfig.getProvider());
        artifact = new SAMLArtifactType0001(srcId, handle);
        return artifact;
    }
}

