/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.ReceiverResource;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionGenerator;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SiteTransfer {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private final String defaultEncoding = "ISO-2022-JP";

    public SiteTransfer(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void forwardTo(String id, String authId, Map attributes) throws SSOException {
        try {
            if (id == null || authId == null) {
                throw new SSOException(SSOMessageResource.getMessage("1002", this.toArray(id, authId, attributes)));
            }
            StringBuffer redirectURL = new StringBuffer();
            String target = this.request.getParameter("TARGET");
            String encodeStr = this.request.getCharacterEncoding();
            if (encodeStr == null || encodeStr.length() < 1) {
                encodeStr = "ISO-2022-JP";
            }
            URL targetURL = new URL(target);
            String context = "";
            String[] s = targetURL.getPath().split("/");
            int i = 0;
            while (i < s.length) {
                if (s[i].length() > 0) {
                    context = s[i];
                    break;
                }
                ++i;
            }
            redirectURL.append(ReceiverResource.getReceiver(targetURL.getHost(), context));
            redirectURL.append("?TARGET=" + URLEncoder.encode(target, encodeStr));
            redirectURL.append("&SAMLart=" + URLEncoder.encode(AssertionGenerator.generateAssertion(id, authId, attributes).encode(), encodeStr));
            this.response.sendRedirect(redirectURL.toString());
        }
        catch (SSOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSOException(SSOMessageResource.getMessage("1001", this.toArray(id, authId, attributes)), e);
        }
    }

    private Object[] toArray(String id, String authId, Map attributes) {
        Object[] array = new Object[]{id, authId, attributes};
        return array;
    }
}

