/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.RequestFailedException;
import info.dragonlady.sso.Requester;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.ResourceParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;

public class ArtifactReceiver {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String authId = null;
    private Map attributes = null;
    private long expirationTime = 0L;
    private String targetUrl = null;

    public ArtifactReceiver(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.targetUrl = request.getParameter("TARGET");
    }

    public void receive(String artifact) throws SSOException {
        SAMLAssertion assertion = null;
        try {
            if (artifact == null || artifact.length() < 1) {
                artifact = this.request.getParameter("SAMLart");
            }
            Requester requester = new Requester();
            assertion = requester.fetchAttribute(artifact);
        }
        catch (RequestFailedException e) {
            throw new SSOException(SSOMessageResource.getMessage("1006", new Object[]{this.targetUrl, artifact}), e);
        }
        this.extract(assertion);
    }

    public String getAuthId() {
        return this.authId;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void redirectToTarget() throws IOException {
        this.response.sendRedirect(this.targetUrl);
    }

    private void extract(SAMLAssertion assertion) throws SSOException {
        String authId = null;
        HashMap attributes = new HashMap();
        Iterator itr = assertion.getStatements();
        while (itr.hasNext() && (authId == null || attributes.isEmpty())) {
            Object statement = itr.next();
            if (statement instanceof SAMLAuthenticationStatement) {
                authId = ((SAMLAuthenticationStatement)statement).getSubject().getNameIdentifier().getName();
            }
            if (!(statement instanceof SAMLAttributeStatement)) continue;
            SAMLAttributeStatement attrStatement = (SAMLAttributeStatement)statement;
            itr = attrStatement.getAttributes();
            while (itr.hasNext()) {
                Object next = itr.next();
                if (!(next instanceof SAMLAttribute)) continue;
                SAMLAttribute attribute = (SAMLAttribute)next;
                String name = attribute.getName();
                Object value = null;
                Iterator values = attribute.getValues();
                while (values.hasNext() && value == null) {
                    value = values.next();
                }
                attributes.put(name, value);
            }
        }
        if (authId != null) {
            try {
                List attributeList = SSOConfig.getSAMLAttributeList();
                ArrayList<String> emptyList = new ArrayList<String>();
                int i = 0;
                while (i < attributeList.size()) {
                    String attrName = (String)attributeList.get(i);
                    if (!attributes.containsKey(attrName)) {
                        emptyList.add(attrName);
                    }
                    ++i;
                }
                if (!emptyList.isEmpty()) {
                    throw new SSOException(SSOMessageResource.getMessage("1007", new Object[]{emptyList}));
                }
            }
            catch (ResourceParseException e) {
                throw new SSOException(SSOMessageResource.getMessage("1008"), e);
            }
            this.authId = authId;
            this.attributes = attributes;
            this.expirationTime = assertion.getNotOnOrAfter().getTime();
        }
    }
}

