/*
 * @(#)AssertionParserTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;
import info.dragonlady.sso.util.ResourceParseException;

import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLDecision;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;

import junit.framework.TestCase;

/**
 * AssertionParserNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/05 18:19:47 $
 */
public class AssertionParserTest extends TestCase {

	/**
	 * @param arg0
	 */
	public AssertionParserTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#AssertionParser(org.opensaml.SAMLAssertion)} ̂߂̃eXgE\bhB
	 */
	public final void testAssertionParser() {
		try {
			new AssertionParser(getAuthAssertion());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getName()} ̂߂̃eXgE\bhB
	 */
	public final void testGetName() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertTrue(parser.getName().equals("dummyId"));
			parser = new AssertionParser(getAttrAssertion());
			assertTrue(parser.getName().equals("dummyId"));
			parser = new AssertionParser(getDecisionAssertion());
			assertTrue(parser.getName().equals("dummyId"));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getAttribute()} ̂߂̃eXgE\bhB
	 */
	public final void testGetAttribute() {
		try {
			Map<String, List<String>> attributes = new HashMap<String, List<String>>();
			List<String> values = new ArrayList<String>();
			values.add("testValue1");
			values.add("testValue2");
			attributes.put("testAttribute1", values);

			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNull(parser.getAttribute());
			parser = new AssertionParser(getAttrAssertion());
			assertEquals(parser.getAttribute(), attributes);
			parser = new AssertionParser(getDecisionAssertion());
			assertNull(parser.getAttribute());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#isPermitted()} ̂߂̃eXgE\bhB
	 */
	public final void testIsPermitted() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertTrue(!parser.isPermitted());
			parser = new AssertionParser(getAttrAssertion());
			assertTrue(!parser.isPermitted());
			parser = new AssertionParser(getDecisionAssertion());
			assertTrue(parser.isPermitted());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getPermittedActions()} ̂߂̃eXgE\bhB
	 */
	public final void testGetPermittedActions() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNull(parser.getPermittedActions());
			parser = new AssertionParser(getAttrAssertion());
			assertNull(parser.getPermittedActions());
			parser = new AssertionParser(getDecisionAssertion());
			assertNotNull(parser.getPermittedActions());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getResource()} ̂߂̃eXgE\bhB
	 */
	public final void testGetResource() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNull(parser.getResource());
			parser = new AssertionParser(getAttrAssertion());
			assertNull(parser.getResource());
			parser = new AssertionParser(getDecisionAssertion());
			assertEquals(parser.getResource(), "dummyResource");
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#containsAuthenticationStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testContainsAuthenticationStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertTrue(parser.containsAuthenticationStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertTrue(!parser.containsAuthenticationStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertTrue(!parser.containsAuthenticationStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#containsAttributeStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testContainsAttributeStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertTrue(!parser.containsAttributeStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertTrue(parser.containsAttributeStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertTrue(!parser.containsAttributeStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#containsDecisionStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testContainsDecisionStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertTrue(!parser.containsDecisionStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertTrue(!parser.containsDecisionStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertTrue(parser.containsDecisionStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getAttributeStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testGetAttributeStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNull(parser.getAttributeStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertNotNull(parser.getAttributeStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertNull(parser.getAttributeStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getAuthenticationStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testGetAuthenticationStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNotNull(parser.getAuthenticationStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertNull(parser.getAuthenticationStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertNull(parser.getAuthenticationStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.util.AssertionParser#getDecisionStatement()} ̂߂̃eXgE\bhB
	 */
	public final void testGetDecisionStatement() {
		try {
			AssertionParser parser = new AssertionParser(getAuthAssertion());
			assertNull(parser.getDecisionStatement());
			parser = new AssertionParser(getAttrAssertion());
			assertNull(parser.getDecisionStatement());
			parser = new AssertionParser(getDecisionAssertion());
			assertNotNull(parser.getDecisionStatement());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private SAMLAssertion getAuthAssertion() throws ResourceParseException, SAMLException {
		String authId = "dummyId";
		String confirmationMethod = SAMLSubject.CONF_ARTIFACT;
		String authMethod = SAMLAuthenticationStatement.AuthenticationMethod_Unspecified;
		return AssertionGenerator.generateAuthenticationAssertion(authId, confirmationMethod, authMethod);
	}

	private SAMLAssertion getAttrAssertion() throws ResourceParseException, SAMLException {
		String authId = "dummyId";
		Map<String, List<String>> attributes = new HashMap<String, List<String>>();
		List<String> values = new ArrayList<String>();
		values.add("testValue1");
		values.add("testValue2");
		attributes.put("testAttribute1", values);

		return AssertionGenerator.generateAttributeAssertion(authId, attributes);
	}

	private SAMLAssertion getDecisionAssertion() throws ResourceParseException, SAMLException {
		String authId = "dummyId";
		String resource = "dummyResource";
		String decision = SAMLDecision.PERMIT;
		List<SAMLAction> actions = new ArrayList<SAMLAction>();
		actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET));
		actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_POST));

		return AssertionGenerator.generateAuthorizationDecisionAssertion(authId, resource, decision, actions);
	}

}
