/*
 * @(#)ResponderResourceTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso;

import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;

import info.dragonlady.sso.ResponderResource;
import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.SSOContext;

/**
 * ResponderResourceNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/11 14:10:23 $
 */
public class ResponderResourceTest extends ServletTestCase {
	private String srcId = "ri2YwDWKf1ZW44AiSnYeAOq+reo=";

	// \zl
	private String responder = "http://172.16.3.74:8080/sso_test/responder.html";

	/**
	 * Constructor for ResponderResourceTest.
	 * @param arg0
	 */
	public ResponderResourceTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResponderResource.getResponder(String)'
	 */
	public final void testGetResponder() {
		try {
			SSOContext.getInstance().setCurrentRequest(request);
			assertTrue(ResponderResource.getResponder(srcId).equals(responder));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	public final void beginGetResponder2(WebRequest theRequest) {
		// ZbVIDw肵ꍇ
		theRequest.addParameter(SSOConstants.NAME_SESSIONID, "dummy_session_id", WebRequest.GET_METHOD);
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResponderResource.getResponder(String)'
	 */
	public final void testGetResponder2() {
		try {
			SSOContext.getInstance().setCurrentRequest(request);
			assertTrue(ResponderResource.getResponder(srcId).equals(responder + ";" + SSOConstants.NAME_SESSIONID + "=dummy_session_id"));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
