/*
 * @(#)AssertionParser.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLDecision;

/**
 * AT[V̓NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/01 12:59:24 $
 */
public class AssertionParser {

	private SAMLAssertion assertion = null;

	private SAMLAuthenticationStatement authStatement = null;

	private SAMLAttributeStatement attrStatement = null;

	private SAMLAuthorizationDecisionStatement decisionStatement = null;

	/**
	 * RXgN^B
	 * 
	 * @param assertion AT[V
	 */
	public AssertionParser(SAMLAssertion assertion) {
		if(assertion != null) {
			this.assertion = assertion;
			extractStatement(assertion);
		}
	}

	private void extractStatement(SAMLAssertion assertion) {
		Iterator itr = assertion.getStatements();
		while(itr.hasNext()) {
			Object statement = itr.next();
			if(statement instanceof SAMLAuthenticationStatement) {
				authStatement = (SAMLAuthenticationStatement)statement;
			} else if(statement instanceof SAMLAttributeStatement) {
				attrStatement = (SAMLAttributeStatement)statement;
			} else if(statement instanceof SAMLAuthorizationDecisionStatement) {
				decisionStatement = (SAMLAuthorizationDecisionStatement)statement;
			}
		}
	}

	/**
	 * FID擾B
	 * 
	 * @return String FID
	 */
	public String getName() {
		String name = null;
		if(authStatement != null) {
			name = authStatement.getSubject().getNameIdentifier().getName();
		} else if(attrStatement != null) {
			name = attrStatement.getSubject().getNameIdentifier().getName();
		} else if(decisionStatement != null) {
			name = decisionStatement.getSubject().getNameIdentifier().getName();
		}
		return name;
	}

	/**
	 * 擾B
	 * 
	 * @return Map<String, List<String>> 
	 */
	public Map<String, List<String>> getAttribute() {
		Map<String, List<String>> attributes = null;
		if(attrStatement != null) {
			attributes = new HashMap<String, List<String>>();
			Iterator<SAMLAttribute> itr = attrStatement.getAttributes();
			while(itr.hasNext()) {
				SAMLAttribute attribute = itr.next();
				String name = attribute.getName();
				List<String> value = new ArrayList<String>();
				Iterator<String> valItr = attribute.getValues();
				while(valItr.hasNext()) {
					value.add(valItr.next());
				}
				attributes.put(name, value);
			}
		}
		return attributes;
	}

	/**
	 * \[Xւ̃ANZXĂ邩ǂB
	 * 
	 * @return boolean trueFĂ^falseFĂȂ
	 */
	public boolean isPermitted() {
		return decisionStatement != null ? decisionStatement.getDecision().equals(SAMLDecision.PERMIT) : false;
	}

	/**
	 * ĂANV擾B
	 * 
	 * @return Iterator<SAMLAction> ĂANV
	 */
	public Iterator<SAMLAction> getPermittedActions() {
		return decisionStatement != null ? decisionStatement.getActions() : null;
	}

	/**
	 * \[Xւ̃pX擾B
	 * 
	 * @return String \[XpX
	 */
	public String getResource() {
		return decisionStatement != null ? decisionStatement.getResource() : null;
	}

	/**
	 * AT[VɔF؃Xe[gg܂܂Ă邩ǂB
	 * 
	 * @return boolean trueF܂܂Ă^falseF܂܂ĂȂ
	 */
	public boolean containsAuthenticationStatement() {
		return authStatement != null;
	}

	/**
	 * AT[VɑXe[gg܂܂Ă邩ǂB
	 * 
	 * @return boolean trueF܂܂Ă^falseF܂܂ĂȂ
	 */
	public boolean containsAttributeStatement() {
		return attrStatement != null;
	}

	/**
	 * AT[VɔFXe[gg܂܂Ă邩ǂB
	 * 
	 * @return boolean trueF܂܂Ă^falseF܂܂ĂȂ
	 */
	public boolean containsDecisionStatement() {
		return decisionStatement != null;
	}

	/**
	 * Xe[gg擾B
	 * 
	 * @return SAMLAttributeStatement Xe[gg
	 */
	public SAMLAttributeStatement getAttributeStatement() {
		return attrStatement;
	}

	/**
	 * F؃Xe[gg擾B
	 * 
	 * @return SAMLAuthenticationStatement F؃Xe[gg
	 */
	public SAMLAuthenticationStatement getAuthenticationStatement() {
		return authStatement;
	}

	/**
	 * FXe[gg擾B
	 * 
	 * @return SAMLAuthorizationDecisionStatement
	 */
	public SAMLAuthorizationDecisionStatement getDecisionStatement() {
		return decisionStatement;
	}

}
