/*
 * @(#)AssertionManager.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceUtils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;


import org.apache.commons.codec.DecoderException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifierFactory;

/**
 * SAMLF؃AT[VǗNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.4 $ $Date: 2006/03/09 14:43:26 $
 */
public class AssertionManager {

	/**
	 * AssertionManagerCX^XB
	 */
	private static final AssertionManager am = new AssertionManager();

	/**
	 * AT[VǗ}bvB
	 * <ul><li>key:AT[Vnh</li>
	 * <li>value:AT[VIuWFNg̕\</li><ul>
	 */
	private volatile Map<String, String> assertionMap = Collections.synchronizedMap(new HashMap<String, String>());

	/**
	 * AT[VIDƃAT[Vnh̃}bvB
	 * <ul><li>key:AT[VID</li>
	 * <li>value:AT[Vnh(base64ŃGR[h)</li><ul>
	 */
	private volatile Map<String, String> handleMap = Collections.synchronizedMap(new HashMap<String, String>());

	private Timer timer = new Timer();

	/**
	 * RXgN^B
	 */
	private AssertionManager() {
	}

	/**
	 * AssertionManagerNX̃CX^X擾B
	 * 
	 * @return AssertionManager CX^X
	 */
	public static AssertionManager getInstance() {
		return am;
	}

	/**
	 * wnhɊ֘AtꂽAT[V擾B
	 * 
	 * @param handle AT[VnhioCgzj
	 * @return SAMLAssertion AT[V
	 * @throws SAMLException
	 */
	public synchronized SAMLAssertion get(byte[] handle) throws SAMLException {
		String assertion = assertionMap.get(ResourceUtils.toHexString(handle));
		// assertionIuWFNgɖ߂
		return assertion != null ? new SAMLAssertion(new ByteArrayInputStream(assertion.getBytes())) : null;
	}

	/**
	 * AT[VIDɊ֘AtꂽAT[V擾B
	 * 
	 * @param id AT[VID
	 * @return SAMLAssertion AT[V
	 * @throws DecoderException
	 */
	public synchronized SAMLAssertion get(String id) throws SAMLException, DecoderException {
		String handleStr = handleMap.get(id);
		return handleStr != null ? get(ResourceUtils.toHexByteArray(handleStr)) : null;
	}

	/**
	 * AT[VǉB
	 * 
	 * @param assertion AT[V
	 * @return byte[] AT[Vnh
	 */
	public synchronized byte[] add(SAMLAssertion assertion) {
		byte[] handle = null;
		while(handle == null ||
				(handle != null && assertionMap.containsKey(ResourceUtils.toBase64String(handle)))) {
			handle = SAMLIdentifierFactory.getInstance().generateRandomBytes(20);
		}

		String handleStr = ResourceUtils.toHexString(handle);
		handleMap.put(assertion.getId(), handleStr);
		// AT[V𕶎ɂĒǉiXMLj
		assertionMap.put(handleStr, assertion.toString());
		// ^C}[ݒ
		timer.schedule(new AssertionTask(assertion.getId()), assertion.getNotOnOrAfter());
		return handle;
	}

	/**
	 * AT[VIDɊ֘AtꂽAT[V폜B
	 * 
	 * @param id AT[VID
	 */
	public synchronized void remove(String id) {
		String handleStr = handleMap.get(id);
		if(handleStr != null) {
			assertionMap.remove(handleStr);
			handleMap.remove(id);
		}
	}

	/**
	 * AT[VnhɊ֘AtꂽAT[V폜B
	 * 
	 * @param handle AT[VnhioCgzj
	 */
	public synchronized void remove(byte[] handle) {
		String handleStr = ResourceUtils.toHexString(handle);
		assertionMap.remove(handleStr);
		// nhID̃}bsO폜
		List<String> id = new ArrayList<String>();
		Iterator keyItr = handleMap.keySet().iterator();
		while(keyItr.hasNext()) {
			Object key = keyItr.next();
			if(handleMap.get(key).equals(handleStr)) {
				id.add(key.toString());
			}
		}
		for(int i = 0; i < id.size(); i++) {
			handleMap.remove(id);
		}
	}

	/**
	 * AT[VnhL[ƂAT[VIuWFNg̃}bv擾B
	 * 
	 * @return Map AT[VǗ}bv
	 */
	public synchronized Map<String, String> getAssertionMap() {
		return assertionMap;
	}

	/**
	 * AT[VnhL[ƂAT[VIuWFNg̃}bvݒB
	 * 
	 * @param map AT[VǗ}bv
	 */
	public synchronized void setAssertionMap(Map<String, String> map) {
		assertionMap = map;
	}

	/**
	 * AT[VIDL[ƂAT[Vnh̃}bv擾B
	 * 
	 * @return Map AT[VnhǗ}bv
	 */
	public synchronized Map<String, String> getHandleMap() {
		return handleMap;
	}

	/**
	 * AT[VIDL[ƂAT[Vnh̃}bvݒB
	 * 
	 * @param map AT[VnhǗ}bv
	 */
	public synchronized void setHandleMap(Map<String, String> map) {
		handleMap = map;
	}

	/**
	 * AT[V̍폜s^XNB
	 * 
	 * @author Hiroshi.Ebata(INFOCITY)
	 * @version $Revision: 1.0 $ $Date: 2007/04/24 18:34:05 $
	 */
	private class AssertionTask extends TimerTask {

		private String id = null;

		private AssertionTask(String id) {
			this.id = id;
		}

		/* (non-Javadoc)
		 * @see java.util.TimerTask#run()
		 */
		@Override
		public void run() {
			AssertionManager.getInstance().remove(id);
			cancel();
		}

	}

}
