/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;

public class AssertionManager {
    private static final AssertionManager am = new AssertionManager();
    private static Map assertionMap = new HashMap();
    private static Map handleMap = new HashMap();

    private AssertionManager() {
    }

    public static AssertionManager getInstance() {
        return am;
    }

    public SAMLAssertion get(byte[] handle) throws SAMLException {
        String assertion = (String)assertionMap.get(ResourceUtils.toBase64String(handle));
        return assertion != null ? new SAMLAssertion((InputStream)new ByteArrayInputStream(assertion.getBytes())) : null;
    }

    public SAMLAssertion get(String id) throws SAMLException {
        String assertion = (String)assertionMap.get((String)handleMap.get(id));
        return assertion != null ? new SAMLAssertion((InputStream)new ByteArrayInputStream(assertion.getBytes())) : null;
    }

    public synchronized byte[] add(SAMLAssertion assertion, String id) {
        byte[] handle = null;
        while (handle == null || handle != null && assertionMap.containsKey(ResourceUtils.toBase64String(handle))) {
            handle = SAMLConfig.instance().getDefaultIDProvider().generateRandomBytes(20);
        }
        this.removeById(id);
        handleMap.put(id, ResourceUtils.toBase64String(handle));
        assertionMap.put(ResourceUtils.toBase64String(handle), assertion.toString());
        return handle;
    }

    public synchronized void removeById(String id) {
        Object handle = handleMap.get(id);
        if (handle != null) {
            assertionMap.remove(handle);
            handleMap.remove(id);
        }
    }

    public synchronized void removeByHandle(byte[] handle) {
        String handleStr = ResourceUtils.toBase64String(handle);
        assertionMap.remove(handleStr);
        Iterator keyItr = handleMap.keySet().iterator();
        while (keyItr.hasNext()) {
            Object key = keyItr.next();
            if (!handleMap.get(key).equals(handleStr)) continue;
            handleMap.remove(key);
        }
    }

    public Map getAssertionMap() {
        return assertionMap;
    }

    public synchronized void setAssertionMap(Map map) {
        assertionMap = map;
    }

    public Map getHandleMap() {
        return handleMap;
    }

    public synchronized void setHandleMap(Map map) {
        handleMap = map;
    }
}

