/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.jetty;

import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.DeployableMonitor;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.container.jetty.Jetty4xEmbeddedContainer;
import org.codehaus.cargo.container.spi.DeployerWatchdog;
import org.codehaus.cargo.util.monitor.MonitoredObject;

public class JettyDeployer
extends MonitoredObject
implements Deployer {
    private Container container;

    public JettyDeployer(Container container) {
        this.container = container;
        this.setMonitor(container.getMonitor());
    }

    protected Container getContainer() {
        return this.container;
    }

    public void deploy(Deployable deployable, DeployableMonitor monitor) {
        this.deploy(deployable);
        DeployerWatchdog watchdog = new DeployerWatchdog(monitor);
        watchdog.setMonitor(this.getMonitor());
        watchdog.waitForDeployment();
    }

    public void deploy(Deployable deployable) {
        this.getMonitor().info("Deploying [" + deployable.getFile().getPath() + "]", this.getClass().getName());
        if (deployable instanceof WAR) {
            try {
                Jetty4xEmbeddedContainer container = (Jetty4xEmbeddedContainer)this.getContainer();
                Object context = container.getServer().getClass().getMethod("addWebApplication", String.class, String.class).invoke(container.getServer(), "/" + ((WAR)deployable).getContext(), deployable.getFile().getPath());
                Class<?> wc = Class.forName("org.mortbay.jetty.servlet.WebApplicationContext");
                wc.getMethod("stop", null).invoke(context, null);
                wc.getMethod("start", null).invoke(context, null);
            }
            catch (Exception e) {
                throw new ContainerException("Failed to deploy [" + deployable.getFile() + "]", e);
            }
        } else {
            throw new ContainerException("Only WAR archives are supported for deployment in Jetty. Got [" + deployable.getFile() + "]");
        }
    }

    public void start(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void stop(Deployable deployable) {
        throw new ContainerException("Not supported");
    }

    public void undeploy(Deployable deployable) {
        throw new ContainerException("Not supported");
    }
}

