/*
 * @(#)SSOContext.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso;

import javax.servlet.http.HttpServletRequest;

import org.opensaml.NoSuchProviderException;
import org.opensaml.ReplayCache;
import org.opensaml.ReplayCacheFactory;

/**
 * SSOt[[NReLXgB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/04/18 20:00:00 $
 */
public class SSOContext {

	private static final SSOContext context = new SSOContext();

	private ReplayCache replayCache = null;

	private ThreadLocal<HttpServletRequest> currentRequest = new ThreadLocal<HttpServletRequest>();

	/**
	 * CX^X擾B
	 * 
	 * @return SSOContext NXCX^X
	 */
	public static final SSOContext getInstance() {
		return context;
	}

	/**
	 * vCLbV擾B
	 * 
	 * @return ReplayCache vCLbV
	 * @throws NoSuchProviderException
	 */
	public synchronized ReplayCache getReplayCache() throws NoSuchProviderException {
		if(replayCache == null) {
			replayCache = ReplayCacheFactory.getInstance();
		}
		return replayCache;
	}

	/**
	 * HTTPv擾B
	 * 
	 * @return HttpServletRequest HTTPv
	 */
	public HttpServletRequest getCurrentRequest() {
		return currentRequest.get();
	}

	/**
	 * HTTPvݒB
	 * 
	 * @param request HTTPv
	 */
	public void setCurrentRequest(HttpServletRequest request) {
		currentRequest.set(request);
	}

}
