/*
 * @(#)UserServiceWrapper.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;

import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;

import org.apache.log4j.Logger;

/**
 * [UǗT[rXNCAgbp[B
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.7 $ $Date: 2006/06/12 13:27:57 $
 */
public class UserServiceWrapper {

	/**
	 * RXgN^B
	 */
	public UserServiceWrapper() {
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗɎw胆[UǉB
	 * 
	 * @param user [U
	 * @param relationId [UƕRÂID
	 * @throws UserServiceException
	 */
	public static final void add(String user, String relationId) throws UserServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[oɃ[Uǉ
					String name = SSOConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					if(service.add(user, relationId)) {
						Logger.getRootLogger().info(SSOMessageResource.getMessage("6320", new Object[]{args, user, relationId}));
					} else {
						Logger.getRootLogger().warn(SSOMessageResource.getMessage("6301", args));
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6302", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6303", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6304", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6305");
			Logger.getRootLogger().error(message, e);
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗ񂩂w胆[U폜B
	 * 
	 * @param user [U
	 * @throws UserServiceException
	 */
	public static final void remove(String user) throws UserServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[U폜
					String name = SSOConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					if(service.remove(user)) {
						Logger.getRootLogger().info(SSOMessageResource.getMessage("6321", new Object[]{args, user}));
					} else {
						Logger.getRootLogger().warn(SSOMessageResource.getMessage("6306", args));
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6307", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6308", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6309", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6310");
			Logger.getRootLogger().error(message, e);
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õ[UǗ񂩂w胆[U폜B
	 * 
	 * @param relationId [UɕRÂID
	 * @throws UserServiceException
	 */
	public static final void removeByRelationId(String relationId) throws UserServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[U폜
					String name = SSOConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					if(service.removeByRelationId(relationId)) {
						Logger.getRootLogger().info(SSOMessageResource.getMessage("6322", new Object[]{args, relationId}));
					} else {
						Logger.getRootLogger().warn(SSOMessageResource.getMessage("6311", args));
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6312", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6313", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6314", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6315");
			Logger.getRootLogger().error(message, e);
			throw new UserServiceException(message, e);
		}
	}

	/**
	 * [JT[õ[UNX^OT[õ[UƓB
	 * 
	 * @throws UserServiceException
	 */
	public static final void synchronize() throws UserServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o烆[Uꗗ擾
					String name = SSOConfig.getServiceName(args[0], args[1], UserService.SERVICE_NAME);
					UserService service = (UserService)Naming.lookup(name);
					Map<String, String> map = service.get();
					if(map != null) {
						// [JT[oɈꗗݒ
						LoginManager lm = LoginManager.getInstance();
						lm.setMap(map);
						Logger.getRootLogger().info(SSOMessageResource.getMessage("6323", args));
						break;
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6316", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6317", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6318", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6319");
			Logger.getRootLogger().error(message, e);
			throw new UserServiceException(message, e);
		}
	}

}
