/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.util;

import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.util.ResourceParseException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.SAMLArtifactType0001;
import org.opensaml.artifact.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionGenerator {
    public static final Artifact generateArtifact(byte[] handle) throws NoSuchAlgorithmException, ResourceParseException {
        SAMLArtifactType0001 artifact = null;
        byte[] srcId = Util.generateSourceId((String)SSOConfig.getProvider());
        artifact = new SAMLArtifactType0001(srcId, handle);
        return artifact;
    }

    public static final SAMLAssertion generateAuthenticationAssertion(String authId, String confirmationMethod, String authMethod) throws ResourceParseException, SAMLException {
        SAMLNameIdentifier identifier = new SAMLNameIdentifier(authId, null, null);
        SAMLSubject subject = new SAMLSubject(identifier, null, null, null);
        subject.addConfirmationMethod(confirmationMethod);
        SAMLAuthenticationStatement statement = new SAMLAuthenticationStatement(subject, authMethod, new Date(), null, null, null);
        SAMLAssertion assertion = AssertionGenerator.createAssertion();
        assertion.addStatement((SAMLStatement)statement);
        return assertion;
    }

    public static final SAMLAssertion generateAttributeAssertion(String authId, Map<String, List<String>> attributes) throws ResourceParseException, SAMLException {
        SAMLNameIdentifier identifier = new SAMLNameIdentifier(authId, null, null);
        SAMLSubject subject = new SAMLSubject(identifier, null, null, null);
        ArrayList<SAMLAttribute> addAttr = new ArrayList<SAMLAttribute>();
        for (String key : attributes.keySet()) {
            SAMLAttribute attribute = new SAMLAttribute(key, SSOConfig.getProvider(), null, 0L, null);
            List<String> values = attributes.get(key);
            int i = 0;
            while (i < values.size()) {
                attribute.addValue((Object)values.get(i));
                ++i;
            }
            addAttr.add(attribute);
        }
        SAMLAttributeStatement statement = new SAMLAttributeStatement(subject, addAttr);
        SAMLAssertion assertion = AssertionGenerator.createAssertion();
        assertion.addStatement((SAMLStatement)statement);
        return assertion;
    }

    public static final SAMLAssertion generateAuthorizationDecisionAssertion(String authId, String resource, String decision, List<SAMLAction> actions) throws ResourceParseException, SAMLException {
        SAMLNameIdentifier identifier = new SAMLNameIdentifier(authId, null, null);
        SAMLSubject subject = new SAMLSubject();
        subject.setNameIdentifier(identifier);
        SAMLAuthorizationDecisionStatement statement = new SAMLAuthorizationDecisionStatement(subject, resource, decision, actions, null);
        SAMLAssertion assertion = AssertionGenerator.createAssertion();
        assertion.addStatement((SAMLStatement)statement);
        return assertion;
    }

    private static final SAMLAssertion createAssertion() throws ResourceParseException, SAMLException {
        Calendar calendar = Calendar.getInstance();
        Date notBefore = calendar.getTime();
        calendar.add(13, SSOConfig.getAssertionLife());
        Date notOnOrAfter = calendar.getTime();
        SAMLAssertion assertion = new SAMLAssertion(SSOConfig.getIssuer(), notBefore, notOnOrAfter, null, null, null);
        return assertion;
    }
}

