/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.AssertionServiceWrapper;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.SiteTransfer;
import info.dragonlady.sso.helper.AttributeGenerator;
import info.dragonlady.sso.helper.AuthenticationException;
import info.dragonlady.sso.helper.Authenticator;
import info.dragonlady.sso.helper.GenerationException;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.servlet.SSOBaseServlet;
import info.dragonlady.sso.util.AssertionGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.SAMLAssertion;
import org.opensaml.artifact.Artifact;

public class SiteTransferServlet
extends SSOBaseServlet {
    private static final long serialVersionUID = -6027017224919602614L;
    protected String paramNameAuthClass = "auth-class";
    protected String paramNameAttrClass = "attr-class";
    protected String paramNameProfileType = "profile-type";
    protected String paramNameForwardPath = "forward-path";

    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Authenticator authenticator;
            String id = null;
            String authId = null;
            String authClass = this.getInitParameter(this.paramNameAuthClass);
            if (authClass != null && authClass.length() > 0 && !(authenticator = (Authenticator)Class.forName(authClass).newInstance()).authenticate(request)) {
                throw new AuthenticationException(SSOMessageResource.getMessage("5001"));
            }
            authId = (String)request.getSession().getAttribute(SSOConfig.getLoginKey());
            Map<String, String> attributes = null;
            String attrClass = this.getInitParameter(this.paramNameAttrClass);
            if (attrClass != null && attrClass.length() > 0) {
                AttributeGenerator attrGenerator = (AttributeGenerator)Class.forName(attrClass).newInstance();
                attributes = attrGenerator.generateAttributesMap(request);
            }
            SiteTransfer st = new SiteTransfer(request, response);
            String profileType = this.getInitParameter(this.paramNameProfileType);
            if (profileType.toUpperCase().equals("ARTIFACT")) {
                SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion(authId, "urn:oasis:names:tc:SAML:1.0:cm:artifact", "urn:oasis:names:tc:SAML:1.0:am:unspecified");
                Artifact artifact = AssertionGenerator.generateArtifact(AssertionManager.getInstance().add(assertion));
                st.forward(Arrays.asList(artifact), attributes);
                id = assertion.getId();
            } else if (profileType.toUpperCase().equals("POST")) {
                SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion(authId, "urn:oasis:names:tc:SAML:1.0:cm:bearer", "urn:oasis:names:tc:SAML:1.0:am:unspecified");
                Map<String, Object> data = st.getPostData(Arrays.asList(assertion), attributes);
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    request.getSession().setAttribute(entry.getKey(), entry.getValue());
                }
                request.getRequestDispatcher(this.getInitParameter(this.paramNameForwardPath)).forward((ServletRequest)request, (ServletResponse)response);
            }
            if (!SSOConfig.isClusterStandalone() && id != null) {
                AssertionServiceWrapper.put(AssertionManager.getInstance().get(id));
            }
        }
        catch (AuthenticationException e) {
            this.processException(SSOMessageResource.getMessage("5002"), e, response, 403);
        }
        catch (GenerationException e) {
            this.processException(SSOMessageResource.getMessage("5003"), e, response, 403);
        }
        catch (SSOException e) {
            this.processException(SSOMessageResource.getMessage("5004"), e, response, 403);
        }
        catch (Exception e) {
            this.processException(SSOMessageResource.getMessage("5005"), e, response, 404);
        }
    }
}

