/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.helper.Authenticator;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.servlet.SSOBaseServlet;
import info.dragonlady.sso.util.AssertionGenerator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opensaml.SAMLAssertion;
import org.opensaml.artifact.Artifact;

public class ArtifactResponderServlet
extends SSOBaseServlet {
    private static final long serialVersionUID = 7145203547625681108L;
    private String paramAuthClass = "auth-class";

    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Authenticator authenticator = (Authenticator)Class.forName(this.getInitParameter(this.paramAuthClass)).newInstance();
            String id = request.getParameter("id");
            if (authenticator.authenticate(request)) {
                SAMLAssertion assertion = AssertionGenerator.generateAuthenticationAssertion(id, "urn:oasis:names:tc:SAML:1.0:cm:artifact", "urn:oasis:names:tc:SAML:1.0:am:unspecified");
                Artifact artifact = AssertionGenerator.generateArtifact(AssertionManager.getInstance().add(assertion));
                String artStr = artifact.encode();
                response.setContentType("text/plain");
                response.setContentLength(artStr.length());
                response.getWriter().write(artStr);
            } else {
                Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("5401", new Object[]{id}));
            }
        }
        catch (Exception e) {
            Logger.getRootLogger().error((Object)SSOMessageResource.getMessage("5402"), (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            throw new ServletException((Throwable)e);
        }
    }
}

