/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.DecoderException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifierFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionManager {
    private static final AssertionManager am = new AssertionManager();
    private volatile Map<String, String> assertionMap = Collections.synchronizedMap(new HashMap());
    private volatile Map<String, String> handleMap = Collections.synchronizedMap(new HashMap());
    private Timer timer = new Timer();

    private AssertionManager() {
    }

    public static final AssertionManager getInstance() {
        return am;
    }

    public synchronized SAMLAssertion get(byte[] handle) throws SAMLException {
        String assertion = this.assertionMap.get(ResourceUtils.toHexString(handle));
        return AssertionManager.toSAMLAssertion(assertion);
    }

    public synchronized SAMLAssertion get(String id) throws SAMLException, DecoderException {
        String handleStr = this.handleMap.get(id);
        return handleStr != null ? this.get(ResourceUtils.toHexByteArray(handleStr)) : null;
    }

    public synchronized byte[] add(SAMLAssertion assertion) {
        byte[] handle = null;
        while (handle == null || handle != null && this.assertionMap.containsKey(ResourceUtils.toHexString(handle))) {
            handle = SAMLIdentifierFactory.getInstance().generateRandomBytes(20);
        }
        this.put(handle, assertion);
        return handle;
    }

    public synchronized void remove(String id) {
        String handleStr = this.handleMap.get(id);
        if (handleStr != null) {
            this.assertionMap.remove(handleStr);
            this.handleMap.remove(id);
        }
    }

    public synchronized void remove(byte[] handle) {
        String handleStr = ResourceUtils.toHexString(handle);
        this.assertionMap.remove(handleStr);
        ArrayList<String> id = new ArrayList<String>();
        for (String key : this.handleMap.keySet()) {
            if (!this.handleMap.get(key).equals(handleStr)) continue;
            id.add(key.toString());
        }
        int i = 0;
        while (i < id.size()) {
            this.handleMap.remove(id);
            ++i;
        }
    }

    public synchronized Map<String, String> getAssertionMap() {
        return Collections.unmodifiableMap(this.assertionMap);
    }

    public synchronized Map<String, String> getHandleMap() {
        return Collections.unmodifiableMap(this.handleMap);
    }

    public synchronized void setMap(Map<String, String> assertionMap, Map<String, String> handleMap) {
        this.clear();
        this.handleMap.putAll(handleMap);
        this.assertionMap.putAll(assertionMap);
        Iterator<String> itr = this.assertionMap.values().iterator();
        while (itr.hasNext()) {
            try {
                this.schedule(AssertionManager.toSAMLAssertion(itr.next().toString()));
            }
            catch (SAMLException sAMLException) {
                // empty catch block
            }
        }
    }

    public synchronized void put(byte[] handle, SAMLAssertion assertion) {
        String handleStr = ResourceUtils.toHexString(handle);
        this.handleMap.put(assertion.getId(), handleStr);
        this.assertionMap.put(handleStr, assertion.toString());
        this.schedule(assertion);
    }

    public synchronized void clear() {
        this.handleMap.clear();
        this.assertionMap.clear();
    }

    public static final SAMLAssertion toSAMLAssertion(String assertionStr) throws SAMLException {
        return assertionStr != null ? new SAMLAssertion((InputStream)new ByteArrayInputStream(assertionStr.getBytes())) : null;
    }

    private void schedule(SAMLAssertion assertion) {
        this.timer.schedule((TimerTask)new AssertionTask(assertion.getId()), assertion.getNotOnOrAfter());
    }

    private class AssertionTask
    extends TimerTask {
        private String id = null;

        private AssertionTask(String id) {
            this.id = id;
        }

        public void run() {
            AssertionManager.getInstance().remove(this.id);
            this.cancel();
        }
    }
}

