/*
 * @(#)SessionAttributeGeneratorTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.helper;

import info.dragonlady.sso.helper.AttributeGenerator;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.helper.SessionAttributeGenerator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


import org.apache.cactus.ServletTestCase;

/**
 * SessionAttributeGenerator NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 13:52:49 $
 */
public class SessionAttributeGeneratorTest extends ServletTestCase {

	/**
	 * @param arg0
	 */
	public SessionAttributeGeneratorTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.helper.SessionAttributeGenerator#SessionAttributeGenerator()} ̂߂̃eXgE\bhB
	 */
	public final void testSessionAttributeGenerator() {
		try {
			new SessionAttributeGenerator();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.SessionAttributeGenerator#generateAttributesMap(javax.servlet.http.HttpServletRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testGenerateAttributesMap() {
		try {
			// \zl
			Map expected = new HashMap();
			Iterator itr = SSOServletConfig.getSessionAttributeKeys().values().iterator();
			while(itr.hasNext()) {
				String key = (String)itr.next();
				String value = key + "_VALUE";
				expected.put(key, value);

				// ZbVɑݒ
				session.setAttribute(key, value);
			}

			AttributeGenerator generator = new SessionAttributeGenerator();
			Map attributes = generator.generateAttributesMap(request);

			// 
			assertTrue(expected.entrySet().size() == attributes.entrySet().size());
			Iterator itr2 = expected.keySet().iterator();
			while(itr2.hasNext()) {
				String key = (String)itr2.next();
				Object value = expected.get(key);
				assertTrue(attributes.containsKey(key));
				assertTrue(attributes.get(key).equals(value));
			}
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
