/*
 * @(#)LoginManagerTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.helper;

import info.dragonlady.sso.helper.LoginManager;
import junit.framework.TestCase;

/**
 * LoginManager NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/09 17:15:31 $
 */
public class LoginManagerTest extends TestCase {

	/**
	 * @param arg0
	 */
	public LoginManagerTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.helper.LoginManager#getInstance()} ̂߂̃eXgE\bhB
	 */
	public final void testGetInstance() {
		try {
			LoginManager lm = LoginManager.getInstance();
			assertTrue(lm != null);
			assertTrue(lm instanceof LoginManager);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.LoginManager#add(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testAdd() {
		try {
			String user = "user";
			String relationId = "relationId";

			LoginManager lm = LoginManager.getInstance();
			lm.add(user, relationId);
			assertTrue(lm.isLoggedIn(user));

			lm.remove(user);
			assertTrue(!lm.isLoggedIn(user));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.LoginManager#remove(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testRemove() {
		try {
			String user = "user";
			String relationId = "relationId";

			LoginManager lm = LoginManager.getInstance();
			lm.add(user, relationId);
			assertTrue(lm.isLoggedIn(user));

			lm.remove(user);
			assertTrue(!lm.isLoggedIn(user));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.helper.LoginManager#isLoggedIn(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testIsLoggedIn() {
		try {
			String user = "user";
			String relationId = "relationId";

			LoginManager lm = LoginManager.getInstance();
			lm.add(user, relationId);
			assertTrue(lm.isLoggedIn(user));

			lm.remove(user);
			assertTrue(!lm.isLoggedIn(user));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
