/*
 * @(#)LoginCheckFilter.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.filter;

import info.dragonlady.sso.helper.Authenticator;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * OCԊmFtB^NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/09/27 18:45:43 $
 */
public class LoginCheckFilter implements Filter {

	private String paramAuthClass = "auth-class"; 

	private String paramRedirection = "redirection"; 

	private String paramIgnore = "ignore"; 

	private String authClassName = null;

	private String redirectionUrl = null;

	private String[] ignorePath = null;

	/**
	 * RXgN^B
	 */
	public LoginCheckFilter() {
		super();
	}

	/**
	 * B
	 * 
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		this.authClassName = config.getInitParameter(this.paramAuthClass);
		this.redirectionUrl = config.getInitParameter(this.paramRedirection);
		String ignore = config.getInitParameter(this.paramIgnore);
		if(ignore != null && ignore.length() > 0) {
			this.ignorePath = ignore.split(",");
		}
	}

	/**
	 * tB^OB
	 * 
	 * @param request vIuWFNg
	 * @param response IuWFNg
	 * @throws IOException
	 * @throws ServletException
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		try {
			// `FbN𖳎pXǂ𔻒f
			boolean ignored = false;
			if(this.ignorePath != null && this.ignorePath.length > 0) {
				String targetPath = ((HttpServletRequest)request).getServletPath();
				for(int i = 0; i < this.ignorePath.length; i++) {
					if(this.ignorePath[i].equals(targetPath)) {
						ignored = true;
						break;
					}
				}
			}
			if(!ignored) {
				// OCԃ`FbN
				Authenticator authenticator = (Authenticator)Class.forName(this.authClassName).newInstance();
				if(!authenticator.authenticate((HttpServletRequest)request)) {
					// OC
					if(!((HttpServletResponse)response).isCommitted()) {
						if(redirectionUrl != null && redirectionUrl.length() > 0) {
							((HttpServletResponse)response).sendRedirect(redirectionUrl);
						} else {
							((HttpServletResponse)response).sendError(HttpServletResponse.SC_FORBIDDEN);
						}
					}
					return;
				}
			}
			chain.doFilter(request, response);
		} catch(IOException e) {
			throw e;
		} catch(ServletException e) {
			throw e;
		} catch(Exception e) {
			throw new ServletException(e);
		}
	}

	/**
	 * IB
	 * 
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

}
