/*
 * @(#)ResourceParseExceptionTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.util;

import info.dragonlady.sso.util.ResourceParseException;
import junit.framework.TestCase;

/**
 * ResourceParseExceptionNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.1 $ $Date: 2005/11/11 14:10:23 $
 */
public class ResourceParseExceptionTest extends TestCase {

	/**
	 * Constructor for ResourceParseExceptionTest.
	 * @param arg0
	 */
	public ResourceParseExceptionTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceParseException.ResourceParseException()'
	 */
	public final void testResourceParseException() {
		try {
			new ResourceParseException();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceParseException.ResourceParseException(String)'
	 */
	public final void testResourceParseExceptionString() {
		try {
			String message = "message";
			new ResourceParseException(message);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceParseException.ResourceParseException(String, Throwable)'
	 */
	public final void testResourceParseExceptionStringThrowable() {
		try {
			String message = "message";
			Exception e = new Exception("exception_message");
			new ResourceParseException(message, e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.ResourceParseException.ResourceParseException(Throwable)'
	 */
	public final void testResourceParseExceptionThrowable() {
		try {
			Exception e = new Exception("exception_message");
			new ResourceParseException(e);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
