/*
 * @(#)SiteTransferServletTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.servlet;

import info.dragonlady.sso.servlet.SiteTransferServlet;

import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.ReceiverResource;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.util.ResourceParseException;

import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;

/**
 * SiteTransferServlet NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/24 18:54:45 $
 */
public class SiteTransferServletTest extends ServletTestCase {

	/**
	 * @param arg0
	 */
	public SiteTransferServletTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.servlet.SiteTransferServlet#SiteTransferServlet()} ̂߂̃eXgE\bhB
	 */
	public final void testSiteTransferServlet() {
		try {
			new SiteTransferServlet();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	public final void beginServiceHttpServletRequestHttpServletResponse(WebRequest theRequest) {
		// ^[QbgTCgwi_~[URLj
		theRequest.addParameter(SSOConstants.NAME_TARGET, "http://172.16.3.74:8080/sso_sample/target.html", WebRequest.GET_METHOD);
	}

	/**
	 * {@link info.dragonlady.sso.servlet.SiteTransferServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)} ̂߂̃eXgE\bhB
	 */
	public final void testServiceHttpServletRequestHttpServletResponse() {
		try {
			int size = AssertionManager.getInstance().getAssertionMap().size();

			session.setAttribute(SSOConfig.getLoginKey(), "testId");
			Map attributes = getAttributes();
			Iterator itr = attributes.keySet().iterator();
			while(itr.hasNext()) {
				Object key = itr.next();
				session.setAttribute(key.toString(), attributes.get(key));
			}

			config.setInitParameter("kind", "1");
			SiteTransferServlet servlet = new SiteTransferServlet();
			servlet.init(config);
			servlet.service(request, response);

			// AT[V̐Ă邱ƂmF
			assertTrue(AssertionManager.getInstance().getAssertionMap().size() > size);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	private final Map getAttributes() throws ResourceParseException {
		Map attributes = new HashMap();
		List keyList = SSOConfig.getSAMLAttributeList();
		for(int i = 0; i < keyList.size(); i++) {
			String key = keyList.get(i).toString();
			attributes.put(key, "val_" + key);
		}
		return attributes;
	}

	public final void endServiceHttpServletRequestHttpServletResponse(WebResponse theResponse) {
		try {
			// URLmF
			String expectedReceiver = ReceiverResource.getReceiver("172.16.3.74", "sso_sample");
			String receiver = theResponse.getConnection().getHeaderField("Location");
			String[] str = receiver.split("\\?");
			assertTrue(expectedReceiver.equals(str[0]));
			String[] query = str[1].split("&");
			for(int i = 0; i < query.length; i++) {
				String[] s = query[i].split("=");
				if(s[0].equals(SSOConstants.NAME_TARGET)) {
					// ^[QbgmF
					String expectedTarget = "http://172.16.3.74:8080/sso_sample/target.html";
					String target = URLDecoder.decode(s[1], "UTF-8");
					assertTrue(expectedTarget.equals(target));
				} else if(s[0].equals(SSOConstants.NAME_SAMLART)) {
					// artifact񑶍݊mF
					assertTrue(s[1] != null && s[1].length() > 0);
				}
			}
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
