/*
 * @(#)PolicyDecisionPointTest.java
 *
 * Copyright (C) 2007 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso.authority;

import info.dragonlady.sso.Requester;
import info.dragonlady.sso.SSOConstants;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLDecision;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;

import junit.framework.TestCase;

/**
 * PolicyDecisionPointNXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2007/06/07 12:55:13 $
 */
public class PolicyDecisionPointTest extends TestCase {

	/**
	 * @param arg0
	 */
	public PolicyDecisionPointTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.sso.authority.PolicyDecisionPoint#query(org.opensaml.SAMLRequest)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery() {
		// ̏ꍇ
		try {
			String authId = "authId";
			SAMLAssertion authAssertion = AssertionGenerator.generateAuthenticationAssertion(authId, "confirmationMethod", "authMethod");
			List<String> values = new ArrayList<String>();
			values.add("attribute_value");
			Map<String, List<String>> attributes = new HashMap<String, List<String>>();
			attributes.put("attribute_name", values);
			SAMLAssertion attrAssertion = AssertionGenerator.generateAttributeAssertion(authId, attributes);

			String decision = SAMLDecision.PERMIT;
			List<SAMLAction> actions = new ArrayList<SAMLAction>();
			actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET));
			actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_POST));

			SAMLAction action = new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET);
			String resource = "resource";
			
			TestPolicyDecisionPoint authority = new TestPolicyDecisionPoint();
			authority.setActions(actions);
			SAMLRequest request = Requester.createAuthorizationDecisionRequest(authAssertion, attrAssertion, action, resource);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.SUCCESS);
			SAMLAssertion assertion = (SAMLAssertion)response.getAssertions().next();
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getDecisionStatement().getSubject().getNameIdentifier().getName().equals(authId));
			assertTrue(parser.getResource().equals(resource));
			assertTrue(parser.getDecisionStatement().getDecision().equals(decision));
			Iterator<SAMLAction> itr = actions.iterator();
			Iterator<SAMLAction> actionItr = parser.getDecisionStatement().getActions();
			while(itr.hasNext()) {
				assertTrue(actionItr.hasNext());
				assertTrue(itr.next().equals(actionItr.next()));
			}
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.sso.authority.PolicyDecisionPoint#decide(java.lang.String, java.util.Map, java.util.Iterator, java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testQuery2() {
		// s̏ꍇ
		try {
			String authId = "authId";
			SAMLAssertion authAssertion = AssertionGenerator.generateAuthenticationAssertion(authId, "confirmationMethod", "authMethod");
			List<String> values = new ArrayList<String>();
			values.add("attribute_value");
			Map<String, List<String>> attributes = new HashMap<String, List<String>>();
			attributes.put("attribute_name", values);
			SAMLAssertion attrAssertion = AssertionGenerator.generateAttributeAssertion(authId, attributes);

			String decision = SAMLDecision.DENY;
			List<SAMLAction> actions = new ArrayList<SAMLAction>();
			actions.add(new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_POST));

			SAMLAction action = new SAMLAction(SAMLAction.SAML_ACTION_NAMESPACE_GHPP, SSOConstants.ACTION_GET);
			String resource = "resource";
			
			TestPolicyDecisionPoint authority = new TestPolicyDecisionPoint();
			authority.setActions(actions);
			SAMLRequest request = Requester.createAuthorizationDecisionRequest(authAssertion, attrAssertion, action, resource);
			SAMLResponse response = authority.query(request);

			assertEquals(response.getStatus().getCodes().next(), SAMLException.SUCCESS);
			SAMLAssertion assertion = (SAMLAssertion)response.getAssertions().next();
			AssertionParser parser = new AssertionParser(assertion);
			assertTrue(parser.getDecisionStatement().getSubject().getNameIdentifier().getName().equals(authId));
			assertTrue(parser.getResource().equals(resource));
			assertTrue(parser.getDecisionStatement().getDecision().equals(decision));
			Iterator<SAMLAction> itr = actions.iterator();
			Iterator<SAMLAction> actionItr = parser.getDecisionStatement().getActions();
			while(itr.hasNext()) {
				assertTrue(actionItr.hasNext());
				assertTrue(itr.next().equals(actionItr.next()));
			}
			assertTrue(assertion.getNotOnOrAfter().getTime() > new Date().getTime());
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
