/*
 * @(#)SSOConfigTest.java
 *
 * Copyright (C) 2005 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.sso;

import info.dragonlady.sso.SSOConfig;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

/**
 * SSOConfigNX̃eXgP[X
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.2 $ $Date: 2005/11/15 19:01:20 $
 */
public class SSOConfigTest extends TestCase {
	// \zl
	private String provider = "http://172.16.3.74:8080/sso_test/";
	private String issuer = "172.16.3.74";
	private List attributes = null;
	private Integer assertionLife = new Integer(3600);

	/**
	 * Constructor for SSOConfigTest.
	 * @param arg0
	 */
	public SSOConfigTest(String arg0) {
		super(arg0);
	}

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		attributes = new ArrayList();
		attributes.add("roleId");
	}

	/*
	 * @see TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/*
	 * Test method for 'info.dragonlady.sso.SSOConfig.getProvider()'
	 */
	public final void testGetProvider() {
		try {
			assertTrue(SSOConfig.getProvider().equals(provider));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.SSOConfig.getIssuer()'
	 */
	public final void testGetIssuer() {
		try {
			assertTrue(SSOConfig.getIssuer().equals(issuer));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.SSOConfig.getSAMLAttributeList()'
	 */
	public final void testGetSAMLAttributeList() {
		try {
			assertTrue(SSOConfig.getSAMLAttributeList().equals(attributes));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/*
	 * Test method for 'info.dragonlady.sso.SSOConfig.getAssertionLife()'
	 */
	public final void testGetAssertionLife() {
		try {
			assertTrue(SSOConfig.getAssertionLife().equals(assertionLife));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	public final void testGetLoginKey() {
		try {
			String expected = "SESSION_ACCOUNT_ID"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOConfig.getLoginKey().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	public final void testGetRedirection() {
		try {
			String expected = "/login.html"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOConfig.getRedirection().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	public final void testGetCooperationService() {
		try {
			String expected = "http://localhost:8080/co-srv/soap/Cooperation"; // ݒt@C̓eɍ킹邱
			assertTrue(SSOConfig.getCooperationService().equals(expected));
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
