/*
 * @(#)ArtifactReceiverServlet.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import info.dragonlady.sso.ArtifactReceiver;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.SSOException;

/**
 * A[eBt@NgMT[ubgB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/10/19 17:39:32 $
 */
public class ArtifactReceiverServlet extends SSOBaseServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4961766901123080450L;

	/**
	 * RXgN^B
	 */
	public ArtifactReceiverServlet() {
		super();
	}

	/**
	 * A[eBt@NgMB
	 * 
	 * @param request HTTPvIuWFNg
	 * @param response HTTPIuWFNg
	 * @throws ServletException
	 * @throws IOException
	 * @see info.dragonlady.sso.servlet.SSOBaseServlet#process(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			ArtifactReceiver receiver = new ArtifactReceiver(request, response);
			// Mvp[^̃A[eBt@NgSAMLvɊ܂߂đMAΉAT[V擾
			receiver.receive();
			// AT[V璊oFIDAɁAړITCgւ̓]邩mF
			String authId = receiver.getAuthId();
			Map attributes = receiver.getAttributes();

			// 擾FIDȂ̑OCZbVɊi[
			HttpSession session = request.getSession();
			session.setAttribute(SSOConfig.getLoginKey(), authId);
			if(attributes != null) {
				Iterator itr = attributes.keySet().iterator();
				while(itr.hasNext()) {
					Object key = itr.next();
					session.setAttribute((String)key, attributes.get(key));
				}
			}
			// OCǗɔFIDǉ
			LoginManager.getInstance().add(authId, session.getId());
			// U̃OC񋤗L
			if(!SSOConfig.isClusterStandalone()) {
				UserServiceWrapper.add(authId, session.getId());
			}

			// ړITCgփ_CNg
			receiver.redirectToTarget();
		} catch(SSOException e) {
			processException(SSOMessageResource.getMessage("5201"), e, response, HttpServletResponse.SC_FORBIDDEN);
		} catch(Exception e) {
			processException(SSOMessageResource.getMessage("5202"), e, response, HttpServletResponse.SC_NOT_FOUND);
		}
	}

}
