/*
 * @(#)SessionAttributeGenerator.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.sso.helper;

import info.dragonlady.sso.SSOConfig;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * ZbVɊi[ꂽlAAT[Vp̃}bv𐶐B
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/11/22 14:07:02 $
 */
public class SessionAttributeGenerator implements AttributeGenerator {

	/**
	 * RXgN^B
	 */
	public SessionAttributeGenerator() {
	}

	/**
	 * ZbVlƂɃAT[V}bv𐶐B
	 * 
	 * @param request HTTPvIuWFNg
	 * @return Map<String, String> AT[V}bv
	 * @throws GenerationException
	 * @see info.dragonlady.sso.helper.AttributeGenerator#generateAttributesMap(javax.servlet.http.HttpServletRequest)
	 */
	public Map<String, String> generateAttributesMap(HttpServletRequest request) throws GenerationException {
		try {
			HttpSession session = request.getSession();
			Iterator itr = SSOConfig.getSAMLAttributeList().iterator();
			Map<String, String> map = new HashMap<String, String>();
			while(itr.hasNext()) {
				String key = (String)itr.next();
				String value = (String)session.getAttribute(key);
				map.put(key, value != null ? value : "");
			}
			return map;
		} catch(Exception e) {
			throw new GenerationException(e);
		}
	}

}
