/*
 * @(#)Crypto.java
 * 
 * Copyright(c) 2005 Infocity Inc. All Rights Reserved.
 */
package info.dragonlady.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

/**
 * ÍENXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version  $Revision: 1.4 $ $Date: 2006/03/09 14:43:01 $
 */
public class Crypto {

	/**
	 * ÍEɎgpL[B
	 */
	private static final byte[] buf = {57, 6, 118, -83, 6, 53, -36, 88, -55, -29, 65, -7, 50, 31, 98, 120};

	/**
	 * ftHgGR[fBOB
	 */
	private static final String defaultCharsetName = "UTF-8";

	/**
	 * ϊASYB
	 */
	private static final String transformation = "AES";

	/**
	 * ÍL[B
	 * 
	 * @return String ÍL[
	 * @throws CryptException
	 */
	public static byte[] generateKey() throws NoSuchAlgorithmException, IllegalStateException {
		KeyGenerator keyGen = KeyGenerator.getInstance(Crypto.transformation);
		keyGen.init(128);
		Key key = keyGen.generateKey();
		return key.getEncoded();
	}

	/**
	 * ÍB
	 * 
	 * @param source ÍΏ
	 * @return byte[] ÍꂽoCgz
	 * @throws CryptException
	 */
	public static byte[] encrypt(byte[] source) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		return Crypto.encrypt(source, Crypto.buf);
	}

	/**
	 * ÍB
	 * 
	 * @param source ÍΏ
	 * @param key ÍL[
	 * @return byte[] ÍꂽoCgz
	 * @throws CryptException
	 */
	public static byte[] encrypt(byte[] source, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		if(source == null) {
			return null;
		}
		SecretKeySpec secretKey = new SecretKeySpec(key, Crypto.transformation);

		Cipher cipher = Cipher.getInstance(Crypto.transformation);
		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		return cipher.doFinal(source);
	}

	/**
	 * ÍB
	 * 
	 * @param source Í镶
	 * @return String Íꂽ
	 * @throws CryptException
	 */
	public static String encrypt(String source) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return Crypto.encrypt(source, Crypto.defaultCharsetName);
	}

	/**
	 * ÍB
	 * 
	 * @param source Í镶
	 * @param charsetName Í镶̕Zbg
	 * @return String Íꂽ
	 * @throws CryptException
	 */
	public static String encrypt(String source, String charsetName) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return encrypt(source, Crypto.defaultCharsetName, Crypto.buf);
	}

	/**
	 * ÍB
	 * 
	 * @param source Í镶
	 * @param key ÍL[
	 * @return String Íꂽ
	 * @throws CryptException
	 */
	public static String encrypt(String source, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return encrypt(source, Crypto.defaultCharsetName, key);
	}

	/**
	 * ÍB
	 * 
	 * @param source Í镶
	 * @param charsetName Í镶̕Zbg
	 * @param key ÍL[
	 * @return String Íꂽ
	 * @throws CryptException
	 */
	public static String encrypt(String source, String charsetName, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		if(source == null) {
			return null;
		}
		byte[] encrypted = Crypto.encrypt(source.getBytes(charsetName), key);
		// bytez16i̕ɕϊ
		return Crypto.toHexString(encrypted);
	}

	/**
	 * B
	 * 
	 * @param encrypted Íꂽ
	 * @return String ꂽ
	 * @throws CryptException
	 */
	public static String decrypt(String encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return Crypto.decrypt(encrypted, Crypto.defaultCharsetName);
	}

	/**
	 * B
	 * 
	 * @param encrypted Íꂽ
	 * @param charsetName 镶̕Zbg
	 * @return String ꂽ
	 * @throws CryptException
	 */
	public static String decrypt(String encrypted, String charsetName) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return Crypto.decrypt(encrypted, Crypto.defaultCharsetName, Crypto.buf);
	}

	/**
	 * B
	 * 
	 * @param encrypted Íꂽ
	 * @param key ÍL[
	 * @return String ꂽ
	 * @throws CryptException
	 */
	public static String decrypt(String encrypted, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		return Crypto.decrypt(encrypted, Crypto.defaultCharsetName, key);
	}

	/**
	 * B
	 * 
	 * @param encrypted Íꂽ
	 * @param charsetName 镶̕Zbg
	 * @param key ÍL[
	 * @return String ꂽ
	 * @throws CryptException
	 */
	public static String decrypt(String encrypted, String charsetName, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
		if(encrypted == null) {
			return null;
		}
		// 16i̕bytezɕϊ
		byte[] encByte = Crypto.toByteArray(encrypted);
		byte[] decrypted = Crypto.decrypt(encByte, key);
		return new String(decrypted, charsetName);
	}

	/**
	 * B
	 * 
	 * @param encrypted ÍꂽoCgz
	 * @return byte[] ꂽoCgz
	 * @throws CryptException
	 */
	public static byte[] decrypt(byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		return Crypto.decrypt(encrypted, Crypto.buf);
	}

	/**
	 * B
	 * 
	 * @param encrypted ÍꂽoCgz
	 * @param key ÍL[
	 * @return byte[] ꂽoCgz
	 * @throws CryptException
	 */
	public static byte[] decrypt(byte[] encrypted, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
		if(encrypted == null) {
			return null;
		}
		SecretKeySpec secretKey = new SecretKeySpec(key, Crypto.transformation);
		Cipher cipher = Cipher.getInstance(Crypto.transformation);
		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		return cipher.doFinal(encrypted);
	}

	/**
	 * w蕶ɑ΂MD5ŃnbVl擾B
	 * 
	 * @param str 
	 * @return String MD5nbV
	 */
	public static String md5(String str) throws NoSuchAlgorithmException {
		return hash("MD5", str);
	}

	/**
	 * w蕶ɑ΂SHA1ŃnbVl擾B
	 * 
	 * @param str 
	 * @return String SHA1nbV
	 */
	public static String sha1(String str) throws NoSuchAlgorithmException {
		return hash("SHA1", str);
	}

	/**
	 * w蕶ɑ΂ĎwASYŃnbVl擾B
	 * 
	 * @param algorithm ASY
	 * @param str 
	 * @return String nbV
	 */
	public static String hash(String algorithm, String str) throws NoSuchAlgorithmException {
		if(str == null) {
			return null;
		}
		MessageDigest md = MessageDigest.getInstance(algorithm);
		md.update(str.getBytes());
		byte[] digest = md.digest();

		return Crypto.toHexString(digest);
	}

	/**
	 * oCgz16iɕϊB
	 * 
	 * @param b oCgz
	 * @return String 16i
	 */
	public static final String toHexString(byte[] b) {
		StringBuffer buffer = new StringBuffer();
		for(int i = 0; i < b.length; i++) {
			String tmp = Integer.toHexString(b[i] & 0xff);
			if (tmp.length() == 1) {
				buffer.append('0').append(tmp);
			} else {
				buffer.append(tmp);
			}
		}
		return buffer.toString();
	}

	/**
	 * 16ioCgzɕϊB
	 * 
	 * @param hex 16i
	 * @return byte[] oCgz
	 */
	public static final byte[] toByteArray(String hex) {
		byte[] b = new byte[hex.length() / 2];
		for(int i = 0; i < hex.length(); i+=2) {
			String byteStr = hex.substring(i, i+2);
			b[i / 2] = new Integer(Integer.parseInt(byteStr, 16)).byteValue();
		}
		return b;
	}

	/**
	 * _ȕ𐶐B
	 * 
	 * @param count ̒
	 * @return String _
	 */
	public static final String random(int count) {
		if (count < 1) {
			return "";
		}
		int end = 'z' + 1;
		int start = ' ';

		char[] buffer = new char[count];
		int gap = end - start;

		while (count-- != 0) {
			Random random = new Random();
			char ch = (char) (random.nextInt(gap) + start);
			if (Character.isLetter(ch) || Character.isDigit(ch)) {
				if(ch >= 56320 && ch <= 57343) {
					if(count == 0) {
						count++;
					} else {
						// low surrogate, insert high surrogate after putting it in
						buffer[count] = ch;
						count--;
						buffer[count] = (char) (55296 + random.nextInt(128));
					}
				} else if(ch >= 55296 && ch <= 56191) {
					if(count == 0) {
						count++;
					} else {
						// high surrogate, insert low surrogate before putting it in
						buffer[count] = (char) (56320 + random.nextInt(128));
						count--;
						buffer[count] = ch;
					}
				} else if(ch >= 56192 && ch <= 56319) {
					// private high surrogate, no effing clue, so skip it
					count++;
				} else {
					buffer[count] = ch;
				}
			} else {
				count++;
			}
		}
		return new String(buffer);
	}

}
