/*
 * @(#)AssertionServiceWrapper.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.message.SSOMessageResource;

import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;

import org.apache.log4j.Logger;
import org.opensaml.SAMLAssertion;

/**
 * AT[VpT[rXbp[NXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.5 $ $Date: 2006/09/26 08:16:04 $
 */
public class AssertionServiceWrapper {

	/**
	 * RXgN^B
	 */
	public AssertionServiceWrapper() {
		super();
	}

	/**
	 * [JT[oyуNX^OT[õAT[VݒB
	 * 
	 * @param assertion AT[V
	 * @throws AssertionServiceException
	 */
	public static final void put(SAMLAssertion assertion) throws AssertionServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[oɏݒ
					String name = SSOConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					// nh擾
					String handleStr = (String)AssertionManager.getInstance().getHandleMap().get(assertion.getId());
					// SAMLAssertionSerializeĂȂׁAStringő
					service.put(handleStr, assertion.toString());
					Logger.getRootLogger().info(SSOMessageResource.getMessage("6113", args));
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6101", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6102", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6103", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6104");
			Logger.getRootLogger().error(message, e);
			throw new AssertionServiceException(message, e);
		}
	}

	/**
	 * [JT[oyуNX^OT[õAT[V񂩂wID̏폜B
	 * 
	 * @param id AT[VǗID
	 * @throws AssertionServiceException
	 */
	public static final void remove(String id) throws AssertionServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o폜
					String name = SSOConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					service.remove(id);
					Logger.getRootLogger().info(SSOMessageResource.getMessage("6114", args));
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6105", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6106", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6107", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6108");
			Logger.getRootLogger().error(message, e);
			throw new AssertionServiceException(message, e);
		}
	}

	/**
	 * [JT[õAT[VNX^OT[õAT[VƓB
	 * 
	 * @throws AssertionServiceException
	 */
	public static final void synchronize() throws AssertionServiceException {
		try {
			Friend[] friends = SSOConfig.getFriends();
			for(int i = 0; i < friends.length; i++) {
				String[] args = {friends[i].getHost(), friends[i].getPort()};
				try {
					// [gT[o擾
					String name = SSOConfig.getServiceName(args[0], args[1], AssertionService.SERVICE_NAME);
					AssertionService service = (AssertionService)Naming.lookup(name);
					Map<String, String> handleMap = service.getHandleMap();
					Map<String, String> assertionMap = service.getAssertionMap();
					if(handleMap != null && assertionMap != null) {
						// [JT[oɏݒ
						AssertionManager.getInstance().setMap(assertionMap, handleMap);
						Logger.getRootLogger().info(SSOMessageResource.getMessage("6115", args));
						break;
					}
				} catch(ConnectException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6109", args), e);
				} catch(NotBoundException e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6110", args), e);
				} catch(Exception e) {
					// szXgƃ|[gԍOo
					Logger.getRootLogger().warn(SSOMessageResource.getMessage("6111", args), e);
				}
			}
		} catch (Exception e) {
			String message = SSOMessageResource.getMessage("6112");
			Logger.getRootLogger().error(message, e);
			throw new AssertionServiceException(message, e);
		}
	}

}
