/*
 * @(#)AssertionServiceImpl.java
 *
 * Copyright 2006 Sony Corporation
 */
package info.dragonlady.cluster;

import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;

import org.apache.log4j.Logger;

import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.ResourceUtils;

/**
 * AT[VpT[rXC^[tF[XNXB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.4 $ $Date: 2006/06/12 13:27:57 $
 */
public class AssertionServiceImpl extends UnicastRemoteObject implements AssertionService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1069975851107064286L;

	/**
	 * RXgN^B
	 * 
	 * @throws RemoteException
	 */
	public AssertionServiceImpl() throws RemoteException {
		super();
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @throws RemoteException
	 */
	public AssertionServiceImpl(int port) throws RemoteException {
		super(port);
	}

	/**
	 * RXgN^B
	 * 
	 * @param port [gIuWFNgĂяoM|[g̔ԍ
	 * @param csf [gIuWFNǧĂяoɎgpANCAg\Pbgt@Ng
	 * @param ssf [gIuWFNgĂяoMAT[o\Pbgt@Ng
	 * @throws RemoteException
	 */
	public AssertionServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
		super(port, csf, ssf);
	}

	/**
	 * AT[VnhAAT[Ṽ}bsOݒB
	 * 
	 * @param handle AT[Vnh
	 * @param assertion AT[V
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#put(java.lang.String, java.lang.String)
	 */
	public synchronized void put(String handle, String assertion) throws RemoteException {
		try {
			AssertionManager am = AssertionManager.getInstance();
			am.put(ResourceUtils.toHexByteArray(handle), AssertionManager.toSAMLAssertion(assertion));
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6007"));
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6001");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

	/**
	 * wnhL[ƂAT[VAAT[Vnh̃}bsO폜B
	 * 
	 * @param handle AT[Vnh
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#remove(byte[])
	 */
	public synchronized void remove(byte[] handle) throws RemoteException {
		try {
			AssertionManager.getInstance().remove(handle);
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6008"));
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6002");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

	/**
	 * wIDL[ƂAT[VAAT[Vnh̃}bsO폜B
	 * 
	 * @param id ID
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#remove(java.lang.String)
	 */
	public synchronized void remove(String id) throws RemoteException {
		try {
			AssertionManager.getInstance().remove(id);
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6009"));
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6003");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[V}bv擾B
	 * 
	 * @return Map<String, String> AT[V}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#getAssertionMap()
	 */
	public synchronized Map<String, String> getAssertionMap() throws RemoteException {
		try {
			Map<String, String> map = AssertionManager.getInstance().getAssertionMap();
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6010"));
			return map;
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6004");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[Vnh}bv擾B
	 * 
	 * @return Map<String, String> AT[Vnh}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#getHandleMap()
	 */
	public synchronized Map<String, String> getHandleMap() throws RemoteException {
		try {
			Map<String, String> map = AssertionManager.getInstance().getHandleMap();
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6011"));
			return map;
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6005");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

	/**
	 * AT[V}bvƃAT[Vnh}bvݒB
	 * 
	 * @param assertionMap AT[V}bv
	 * @param handleMap AT[Vnh}bv
	 * @throws RemoteException
	 * @see info.dragonlady.cluster.AssertionService#setMap(java.util.Map, java.util.Map)
	 */
	public synchronized void setMap(Map<String, String> assertionMap, Map<String, String> handleMap) throws RemoteException {
		try {
			AssertionManager.getInstance().setMap(assertionMap, handleMap);
			Logger.getRootLogger().info(SSOMessageResource.getMessage("6012"));
		} catch(Exception e) {
			String message = SSOMessageResource.getMessage("6006");
			Logger.getRootLogger().error(message, e);
			throw new RemoteException(message, e);
		}
	}

}
