package info.dragonlady.scriptlet.demo;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import info.dragonlady.scriptlet.ESEngine;
import info.dragonlady.scriptlet.ESException;
import info.dragonlady.scriptlet.Scriptlet;

/**
 * CharSetにUTF-8を設定するScriptletクラス
 * @author nobu
 *
 */
public class UTF8Scriptlet extends Scriptlet {
	private static final long serialVersionUID = -8629102473475113008L;

	@Override
	public Map<String, Object> getScriptNewProperties() {
		return null;
	}

	@Override
	public long getSerialVersionUID() {
		return serialVersionUID;
	}
	
	@Override
	public String getInitSequence() {
		return null;
	}

	@Override
	public String getNextInitSequence() {
		return null;
	}
	
	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		try {
			ESEngine.executeScript(this);
		}
		catch(ESException e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(403, e.getMessage());
		}
	}
	
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		doPost(req, res);
	}

	protected String getCharSet() {
		return "UTF-8";
	}

	@Override
	public String getEScriptErrorMsg() {
		return "サーバスクリプトに問題があります。";
	}

	@Override
	public String getInvalidParamErrorMsg() {
		return "パラメータに不備があります。";
	}

	@Override
	public String getRequiredParamErrorMsg() {
		return "パラメータは必須です。";
	}

	@Override
	public String getInvalidValidationParamErrorMsg() {
		return "servervalidationパラメータに不備があります。";
	}
}
