/*
 * @(#)ServerUrlManagerTest.java
 *
 * Copyright (C) 2006 Infocity Inc. All Rights Reserved.
 */
package test.info.dragonlady.system.service;

import info.dragonlady.system.service.ServerUrlManager;

import java.util.List;

import junit.framework.TestCase;

/**
 * ServerUrlManager NXeXgP[XB
 * 
 * @author Hiroshi.Ebata(INFOCITY)
 * @version $Revision: 1.0 $ $Date: 2006/12/12 2:07:48 $
 */
public class ServerUrlManagerTest extends TestCase {

	/**
	 * @param arg0
	 */
	public ServerUrlManagerTest(String arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	/* (non-Javadoc)
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		super.tearDown();
	}

	/**
	 * {@link info.dragonlady.system.service.ServerUrlManager#getInstance()} ̂߂̃eXgE\bhB
	 */
	public final void testGetInstance() {
		try {
			assertTrue(ServerUrlManager.getInstance() != null);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.system.service.ServerUrlManager#add(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testAdd() {
		try {
			ServerUrlManager sum = ServerUrlManager.getInstance();
			assertTrue(sum.getList().size() == 0);
			assertTrue(sum.add("testurl"));
			assertTrue(sum.getList().size() == 1);
			sum.removeAll();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.system.service.ServerUrlManager#remove(java.lang.String)} ̂߂̃eXgE\bhB
	 */
	public final void testRemove() {
		try {
			ServerUrlManager sum = ServerUrlManager.getInstance();
			assertTrue(sum.getList().size() == 0);
			assertTrue(sum.add("testurl"));
			assertTrue(sum.getList().size() == 1);
			assertTrue(sum.remove("testurl"));
			assertTrue(sum.getList().size() == 0);
			sum.removeAll();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.system.service.ServerUrlManager#removeAll()} ̂߂̃eXgE\bhB
	 */
	public final void testRemoveAll() {
		try {
			ServerUrlManager sum = ServerUrlManager.getInstance();
			assertTrue(sum.getList().size() == 0);
			assertTrue(sum.add("testurl"));
			assertTrue(sum.add("testurl2"));
			assertTrue(sum.getList().size() == 2);
			assertTrue(sum.removeAll());
			assertTrue(sum.getList().size() == 0);
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

	/**
	 * {@link info.dragonlady.system.service.ServerUrlManager#getList()} ̂߂̃eXgE\bhB
	 */
	public final void testGetList() {
		try {
			ServerUrlManager sum = ServerUrlManager.getInstance();
			assertTrue(sum.add("testurl"));
			assertTrue(sum.add("testurl2"));
			List list = sum.getList();
			assertTrue(list.size() == 2);
			assertTrue(list.contains("testurl"));
			assertTrue(list.contains("testurl2"));
			sum.removeAll();
		} catch(Exception e) {
			assertTrue(e.toString(), false);
		}
	}

}
