/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet.mail;

import info.dragonlady.scriptlet.ESEngine;
import info.dragonlady.scriptlet.mail.DefaultMailScriptlet;
import info.dragonlady.scriptlet.mail.MailReceivedException;
import info.dragonlady.util.DBAccesser;
import info.dragonlady.util.SmtpParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    protected BufferedInputStream bis = null;
    protected static String defualtSupportMailAddr = "nobu@dragonlady.info";
    public static final String _debug = "__DEBUG__";

    protected Main(InputStream is) {
        this.bis = new BufferedInputStream(is);
    }

    protected void start(Map<String, Object> jsObjectMap, Properties properties, Vector<String> mimeList) throws MailReceivedException {
        StringBuffer readData = new StringBuffer();
        byte[] readBuff = new byte[1024];
        int readLen = 0;
        byte[] allReadData = null;
        try {
            DBAccesser dba = new DBAccesser(properties);
            while ((readLen = this.bis.read(readBuff, 0, 1024)) > 0) {
                if (allReadData == null) {
                    allReadData = new byte[readLen];
                    System.arraycopy(readBuff, 0, allReadData, 0, readLen);
                    continue;
                }
                byte[] tempBuff = new byte[allReadData.length];
                System.arraycopy(allReadData, 0, tempBuff, 0, tempBuff.length);
                allReadData = new byte[allReadData.length + readLen];
                System.arraycopy(tempBuff, 0, allReadData, 0, tempBuff.length);
                System.arraycopy(readBuff, 0, allReadData, tempBuff.length, readLen);
            }
            readData.append(new String(allReadData, 0, allReadData.length, "ISO-2022-JP"));
            SmtpParser smtp = SmtpParser.parse(readData.toString(), properties, mimeList);
            ESEngine.executeScript(smtp, jsObjectMap, dba, new DefaultMailScriptlet());
        }
        catch (Exception e) {
            throw new MailReceivedException(e);
        }
    }

    public static void main(String[] args) {
        Main main = new Main(System.in);
        File debugFile = new File("/var/tmp/" + Calendar.getInstance().getTimeInMillis() + "_moblog.log");
        FileOutputStream fos = null;
        try {
            String line;
            Vector<String> mimeList = new Vector<String>();
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL propertiesResource = cl.getResource("info/dragonlady/scriptlet/mail/resources/mime_type.csv");
            BufferedReader reader = new BufferedReader(new InputStreamReader(propertiesResource.openStream()));
            while ((line = reader.readLine()) != null) {
                if (line == null || line.length() <= 0 || line.indexOf(",") <= 0) continue;
                mimeList.add(line);
            }
            propertiesResource = cl.getResource("info/dragonlady/scriptlet/mail/resources/mail_config.xml");
            Properties properties = new Properties();
            properties.loadFromXML(propertiesResource.openStream());
            System.setProperty("java.security.policy", properties.getProperty("default_policy"));
            System.setSecurityManager(new SecurityManager());
            fos = new FileOutputStream(debugFile);
            System.setOut(new PrintStream(fos));
            String objectMapXml = args[0];
            HashMap<String, Object> jsObjectMap = new HashMap<String, Object>();
            if (objectMapXml != null && objectMapXml.length() > 1) {
                Properties prop = new Properties();
                prop.loadFromXML(new BufferedInputStream(new FileInputStream(objectMapXml)));
                Set<Object> keys = prop.keySet();
                for (Object key : keys) {
                    if (key == null || key.toString().length() <= 0) continue;
                    String className = prop.getProperty(key.toString());
                    Class<?> loadClass = ClassLoader.getSystemClassLoader().loadClass(className);
                    jsObjectMap.put(key.toString(), loadClass.newInstance());
                }
            }
            main.start(jsObjectMap, properties, mimeList);
        }
        catch (Exception e) {
            try {
                e.printStackTrace(new PrintStream(fos));
                fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
        try {
            fos.close();
            debugFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }
}

