/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.ResourceParseException;
import info.dragonlady.sso.util.ResourceUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NodeList;

public class SSOConfig {
    private static final String resourcePath = "resources/sso_config.xml";

    public static final String getProvider() throws ResourceParseException {
        String expression = "sso/provider";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final String getIssuer() throws ResourceParseException {
        String expression = "sso/issuer";
        return ResourceUtils.getString(resourcePath, expression);
    }

    public static final List getSAMLAttributeList() throws ResourceParseException {
        String expression = "sso/saml_attribute/name";
        NodeList nodeList = ResourceUtils.getNodeSet(resourcePath, expression);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < nodeList.getLength()) {
            list.add(ResourceUtils.getTextContent(nodeList.item(i)));
            ++i;
        }
        return list;
    }

    public static final Integer getAssertionLife() throws ResourceParseException {
        String expression = "sso/assertion_life";
        return new Integer(ResourceUtils.getString(resourcePath, expression));
    }
}

