/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet;

import info.dragonlady.scriptlet.ESCylinder;
import info.dragonlady.scriptlet.ESException;
import info.dragonlady.scriptlet.Scriptlet;
import info.dragonlady.util.DocumentA;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ESEngine {
    protected static final String serverScriptTag = "<serverscript>";
    protected static final String serverValidationTag = "<servervalidation>";
    protected static final String serverScriptEndTag = "</serverscript>";
    protected static final String serverValidationEndTag = "</servervalidation>";
    protected static final String bodyTagOnloadAttrPt = ".*\\<\\s*body[^\\>]+onloadserver=['\"]([^\\)]+\\))['\"].+";
    protected static final String scriptLoadAttrPt = ".*\\<\\s*serverscript[^\\>]+src=['\"]([^'\"]+)['\"].+";
    protected static final String defaultScriptletCharcode = "utf-8";
    protected String contentCharcode = "utf-8";
    protected StringWriter bufferWriter = new StringWriter();
    private static HashMap<String, String> scriptsMap = new HashMap();
    private static HashMap<String, Long> scriptsLastModify = new HashMap();
    private String scriptPath = "";
    private static final String initSuffix = "_init.ses";
    private static final String execSuffix = "_exec.ses";
    private static final String errorSufttix = "_error.ses";

    private ESEngine() {
    }

    protected final HtmlParser craeteHtmlParser(ESCylinder cylinder) throws IOException {
        return new HtmlParser(cylinder, this.bufferWriter);
    }

    protected final String loadScript(File file) throws FileNotFoundException, IOException {
        StringBuffer script = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), defaultScriptletCharcode));
        String line = null;
        boolean hasMetaTag = false;
        String charCode = null;
        while ((line = reader.readLine()) != null) {
            if (line.toLowerCase().indexOf("meta") > -1) {
                hasMetaTag = true;
            }
            if (hasMetaTag && line.toLowerCase().indexOf("charset=") > -1) {
                String metaCharsetValue = line.substring(line.toLowerCase().indexOf("charset=") + "charset=".length());
                Pattern p = Pattern.compile("(^[a-zA-Z0-9\\-_]+).*");
                Matcher m = p.matcher(metaCharsetValue);
                if (!m.matches()) break;
                charCode = m.group(1);
                break;
            }
            script.append(line);
            script.append("\n");
        }
        reader.close();
        if (charCode != null) {
            this.contentCharcode = charCode;
            script = new StringBuffer();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charCode));
            while ((line = reader.readLine()) != null) {
                script.append(line);
                script.append("\n");
            }
        }
        return script.toString();
    }

    protected void initialize(String basePath) throws FileNotFoundException, IOException {
        File scriptsDir;
        if (scriptsMap.size() < 2 && (scriptsDir = new File(basePath)).isDirectory()) {
            int i = 0;
            while (i < scriptsDir.listFiles().length) {
                if (!scriptsDir.listFiles()[i].isDirectory()) {
                    scriptsMap.put(scriptsDir.list()[i], this.loadScript(scriptsDir.listFiles()[i]));
                    scriptsLastModify.put(scriptsDir.list()[i], scriptsDir.listFiles()[i].lastModified());
                }
                ++i;
            }
        }
    }

    protected static String createOnLoadScript(Scriptlet scriptlet, String fileName, String functionName) throws InvalidPropertiesFormatException, FileNotFoundException, IOException {
        String paramPath = String.valueOf(scriptlet.getServletContext().getRealPath("/")) + "WEB-INF" + File.separator + "config.xml";
        Properties prop = new Properties();
        prop.loadFromXML(new FileInputStream(paramPath));
        return String.format(prop.getProperty("onloadTemplate"), fileName, functionName);
    }

    public String getContentCharcode() {
        return this.contentCharcode;
    }

    public static void executeScript(Scriptlet scriptlet) throws ESException {
        ESCylinder cylinder = null;
        String errorFileName = null;
        ESEngine engine = new ESEngine();
        try {
            try {
                engine.scriptPath = scriptlet.getScriptletPath();
                engine.initialize(engine.scriptPath);
                String scriptFileName = scriptlet.getRequest().getRequestURL().toString();
                scriptFileName = scriptFileName.endsWith("/") ? "index" : scriptFileName.substring(scriptFileName.lastIndexOf("/") + 1);
                errorFileName = String.valueOf(scriptFileName) + errorSufttix;
                scriptFileName = scriptlet.isExecute() ? String.valueOf(scriptFileName) + execSuffix : String.valueOf(scriptFileName) + initSuffix;
                File scriptFile = new File(String.valueOf(engine.scriptPath) + scriptFileName);
                if (scriptsLastModify.get(scriptFileName).longValue() != scriptFile.lastModified()) {
                    scriptsMap.put(scriptFileName, engine.loadScript(scriptFile));
                    scriptsLastModify.put(scriptFileName, scriptFile.lastModified());
                }
                scriptlet.setCharSet(engine.getContentCharcode());
                File errorFile = new File(String.valueOf(engine.scriptPath) + errorFileName);
                if (errorFile.exists()) {
                    scriptsMap.put(errorFileName, engine.loadScript(errorFile));
                    scriptsLastModify.put(errorFileName, errorFile.lastModified());
                }
                String script = scriptsMap.get(scriptFileName);
                cylinder = ESCylinder.createInstanse(scriptlet, engine.bufferWriter);
                HtmlParser htmlParser = engine.craeteHtmlParser(cylinder);
                htmlParser.parse(script);
                engine.bufferWriter.flush();
                engine.bufferWriter.close();
                if (htmlParser.isNormalizeXML() && htmlParser.getOnLoadFunction() != null && htmlParser.getOnLoadFunction().length() > 2 && htmlParser.getLoadScriptFileName() != null && htmlParser.getLoadScriptFileName().length() > 1) {
                    String onLoadScript = ESEngine.createOnLoadScript(scriptlet, htmlParser.getLoadScriptFileName(), htmlParser.getOnLoadFunction());
                    cylinder.process(onLoadScript, engine.scriptPath);
                    StringBuffer result = new StringBuffer();
                    ESEngine.print(htmlParser.getHTMLDocuemnt(), result);
                    scriptlet.getResponse().getWriter().write(result.toString());
                } else {
                    scriptlet.getResponse().getWriter().write(engine.bufferWriter.toString());
                }
                scriptlet.setSequence();
            }
            catch (Exception e) {
                if (cylinder != null) {
                    cylinder.exit();
                    cylinder = null;
                }
                scriptlet.setCharSet(engine.getContentCharcode());
                ESEngine.exceptionProc(scriptlet, e);
            }
        }
        finally {
            if (cylinder != null) {
                cylinder.exit();
            }
        }
    }

    public String getScriptletDirPath() {
        return this.scriptPath;
    }

    public static void exceptionProc(Scriptlet scriptlet, Exception e) throws ESException {
        ESEngine engine = new ESEngine();
        engine.scriptPath = scriptlet.getScriptletPath();
        String errorFileName = scriptlet.getRequest().getRequestURL().toString();
        errorFileName = errorFileName.endsWith("/") ? "index" : errorFileName.substring(errorFileName.lastIndexOf("/") + 1);
        errorFileName = String.valueOf(errorFileName) + errorSufttix;
        ESCylinder cylinder = null;
        if (scriptsMap.containsKey(errorFileName)) {
            try {
                String script = scriptsMap.get(errorFileName);
                cylinder = ESCylinder.createInstanse(scriptlet, engine.bufferWriter);
                ESException ex = new ESException(e);
                ex.setInitFullURL(scriptlet.getRequest().getRequestURL().toString());
                ex.setInitURL(scriptlet.getRequest().getServletPath());
                cylinder.setException(ex);
                HtmlParser htmlParser = engine.craeteHtmlParser(cylinder);
                htmlParser.parse(script);
                engine.bufferWriter.flush();
                engine.bufferWriter.close();
                scriptlet.getResponse().getWriter().write(engine.bufferWriter.toString());
                scriptlet.setSequence();
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new ESException(e);
            }
        } else {
            throw new ESException(e);
        }
    }

    protected static void print(Node node, StringBuffer buffer) {
        StringBuffer result = buffer;
        if (result == null) {
            result = new StringBuffer();
        }
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                Document doc = (Document)node;
                DocumentType docType = doc.getDoctype();
                if (docType != null) {
                    String dtdName = docType.getName();
                    String interSub = docType.getInternalSubset();
                    String PubID = docType.getPublicId();
                    String SysID = docType.getSystemId();
                    if (interSub != null) {
                        result.append("<!DOCTYPE " + dtdName + "[\n");
                        result.append(interSub);
                        result.append("]>\n");
                    } else if (dtdName != null) {
                        if (PubID != null) {
                            result.append("<!DOCTYPE " + dtdName + " PUBLIC " + "\"" + PubID + "\">\n");
                        }
                        if (SysID != null) {
                            result.append("<!DOCTYPE " + dtdName + " SYSTEM " + "\"" + SysID + "\">\n");
                        }
                    }
                }
                ESEngine.print(doc.getDocumentElement(), result);
                break;
            }
            case 1: {
                result.append('<');
                result.append(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    if (ESEngine.escape(attrs.item(i).getNodeValue()) != null && ESEngine.escape(attrs.item(i).getNodeValue()).length() > 0) {
                        result.append(' ');
                        result.append(attrs.item(i).getNodeName());
                        result.append("=\"");
                        result.append(ESEngine.escape(attrs.item(i).getNodeValue()));
                        result.append("\"");
                    }
                    ++i;
                }
                if (node.hasChildNodes()) {
                    result.append(">");
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    if (children.getLength() > 1 || children.getLength() == 1 && children.item(0).getNodeType() != 3) {
                        result.append("\n");
                    }
                    int i2 = 0;
                    while (i2 < children.getLength()) {
                        ESEngine.print(children.item(i2), result);
                        ++i2;
                    }
                    break;
                }
                result.append("/>");
                result.append("\n");
                break;
            }
            case 5: {
                result.append("&");
                result.append(node.getNodeName());
                result.append(";");
                break;
            }
            case 4: {
                result.append("<![CDATA[");
                result.append(node.getNodeValue());
                result.append("]]>");
                result.append("\n");
                break;
            }
            case 3: {
                result.append(ESEngine.escape(node.getNodeValue()));
                break;
            }
            case 7: {
                result.append("<?");
                result.append(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    result.append(" ");
                    result.append(data);
                }
                result.append("?>");
                result.append("\n");
            }
        }
        if (node.getNodeType() == 1 && node.hasChildNodes()) {
            result.append("</");
            result.append(node.getNodeName());
            result.append(">");
            result.append("\n");
        }
    }

    protected static String escape(String target) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        String checkTarget = target.replaceAll("[\\n\\r\\s\\t]", "");
        if (checkTarget.length() < 1) {
            return "";
        }
        int len = target != null ? target.length() : 0;
        i = 0;
        while (i < len) {
            char ch = target.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private class ParseErrorHandler
    implements ErrorHandler {
        private ParseErrorHandler() {
        }

        public void warning(SAXParseException e) {
            System.err.println("WARN: " + e.getLineNumber());
            System.err.println(e.getMessage());
        }

        public void error(SAXParseException e) {
            System.err.println("ERROR: " + e.getLineNumber());
            System.err.println(e.getMessage());
        }

        public void fatalError(SAXParseException e) {
            System.err.println("FATAL: " + e.getLineNumber());
            System.err.println(e.getMessage());
        }
    }

    private class HtmlParser {
        protected ESCylinder cylinder = null;
        protected String onLoadFunction = null;
        protected String loadScript = null;
        protected StringWriter writer = null;
        protected DocumentA document = null;

        public HtmlParser(ESCylinder cyl, StringWriter w) throws IOException {
            this.cylinder = cyl;
            this.writer = w;
        }

        public void parse(String script) throws ESException {
            int scriptIdx = script.indexOf(ESEngine.serverScriptTag);
            int validateIdx = script.indexOf(ESEngine.serverValidationTag);
            if (scriptIdx > 0 || validateIdx > 0) {
                if (scriptIdx > 0 && scriptIdx < validateIdx || validateIdx < 0) {
                    this.writer.write(script.substring(0, scriptIdx));
                    this.writer.flush();
                    this.parse(this.execScript(script.substring(scriptIdx + ESEngine.serverScriptTag.length())));
                    this.writer.flush();
                } else if (validateIdx > 0 && validateIdx < scriptIdx || scriptIdx < 0) {
                    this.writer.write(script.substring(0, validateIdx));
                    this.writer.flush();
                    this.parse(this.execValidation(script.substring(validateIdx + ESEngine.serverValidationTag.length())));
                    this.writer.flush();
                }
            }
            if (scriptIdx < 0 && validateIdx < 0) {
                this.writer.write(script);
                this.writer.flush();
            }
        }

        public Document getHTMLDocuemnt() {
            return this.document;
        }

        public boolean isNormalizeXML() {
            try {
                this.checkHTML(this.writer.toString());
                if (this.getOnLoadFunction() != null && this.getOnLoadFunction().length() > 2 && this.getLoadScriptFileName() != null && this.getLoadScriptFileName().length() > 1) {
                    StringReader sr = new StringReader(this.writer.toString());
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    builder.setErrorHandler(new ParseErrorHandler());
                    InputSource is = new InputSource(sr);
                    this.document = new DocumentA(builder.parse(is));
                    this.cylinder.addDocumentObject(this.document);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            return false;
        }

        public String getOnLoadFunction() {
            return this.onLoadFunction;
        }

        public String getLoadScriptFileName() {
            return this.loadScript;
        }

        protected void checkHTML(String script) {
            Pattern p = Pattern.compile(ESEngine.bodyTagOnloadAttrPt, 106);
            Matcher m = p.matcher(script);
            if (m.matches()) {
                this.onLoadFunction = m.group(1);
            }
            if ((m = (p = Pattern.compile(ESEngine.scriptLoadAttrPt, 106)).matcher(script)).matches()) {
                this.loadScript = m.group(1);
            }
        }

        protected String execScript(String script) throws ESException {
            int scriptIdx = script.indexOf(ESEngine.serverScriptEndTag);
            String scriptValue = this.removeStartLF(script.substring(0, scriptIdx));
            this.cylinder.process(scriptValue, ESEngine.this.getScriptletDirPath());
            return script.substring(scriptIdx + ESEngine.serverScriptEndTag.length());
        }

        protected String execValidation(String script) throws ESException {
            int validateIdx = script.indexOf(ESEngine.serverValidationEndTag);
            String validationValue = this.removeStartLF(script.substring(0, validateIdx));
            this.cylinder.validate(validationValue);
            return script.substring(validateIdx + ESEngine.serverValidationEndTag.length());
        }

        private String removeStartLF(String value) {
            if (value.startsWith("\n")) {
                return value.substring(1);
            }
            return value;
        }
    }
}

