/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.listener;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.SSOConfig;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class LoginSessionListener
implements HttpSessionListener {
    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            HttpSession session = event.getSession();
            if (session != null) {
                String id = (String)session.getAttribute(SSOConfig.getLoginKey());
                if (id != null) {
                    LoginManager.getInstance().remove(id);
                    if (!SSOConfig.isClusterStandalone()) {
                        UserServiceWrapper.remove(id);
                    }
                } else {
                    String sessionId = session.getId();
                    LoginManager.getInstance().removeById(sessionId);
                    if (!SSOConfig.isClusterStandalone()) {
                        UserServiceWrapper.removeByRelationId(sessionId);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getRootLogger().error((Object)SSOMessageResource.getMessage("4001"), (Throwable)e);
        }
    }
}

