/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.authority;

import info.dragonlady.sso.authority.AuthorityException;
import info.dragonlady.sso.authority.SAMLAuthority;
import info.dragonlady.sso.message.SSOMessageResource;
import info.dragonlady.sso.util.AssertionGenerator;
import info.dragonlady.sso.util.AssertionParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeAuthority
implements SAMLAuthority {
    @Override
    public final SAMLResponse query(SAMLRequest request) throws AuthorityException {
        try {
            SAMLResponse response = new SAMLResponse(request.getId(), null, null, null);
            SAMLException samlException = null;
            String authId = null;
            ArrayList<String> attributeNames = new ArrayList<String>();
            try {
                SAMLAttributeQuery query = (SAMLAttributeQuery)request.getQuery();
                SAMLSubject subject = query.getSubject();
                SAMLAssertion authAssertion = new SAMLAssertion();
                authAssertion.fromDOM((Element)subject.getConfirmationData().getFirstChild());
                authId = new AssertionParser(authAssertion).getName();
                Iterator itr = query.getDesignators();
                while (itr.hasNext()) {
                    attributeNames.add(((SAMLAttributeDesignator)itr.next()).getName());
                }
            }
            catch (Exception e) {
                samlException = new SAMLException(SAMLException.REQUESTER, SSOMessageResource.getMessage("2101"), e);
            }
            if (samlException == null) {
                try {
                    Map<String, List<String>> attributes = this.getAttributes(authId, attributeNames);
                    SAMLAssertion assertion = AssertionGenerator.generateAttributeAssertion(authId, attributes);
                    response.addAssertion(assertion);
                    samlException = new SAMLException(SAMLException.SUCCESS);
                }
                catch (Exception e) {
                    samlException = new SAMLException(SAMLException.RESPONDER, SSOMessageResource.getMessage("2102"), e);
                }
            }
            response.setStatus(samlException);
            return response;
        }
        catch (Exception e) {
            throw new AuthorityException(SSOMessageResource.getMessage("2103"), e);
        }
    }

    protected abstract Map<String, List<String>> getAttributes(String var1, List<String> var2) throws AuthorityException;
}

