/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso;

import info.dragonlady.sso.util.AssertionParser;
import java.util.Date;
import java.util.List;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttributeDesignator;
import org.opensaml.SAMLAttributeQuery;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLBinding;
import org.opensaml.SAMLBindingFactory;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifierFactory;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensaml.XML;
import org.opensaml.artifact.Artifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Requester
implements SAMLBrowserProfile.ArtifactMapper {
    private String responder = null;

    public Requester(String responder) {
        this.responder = responder;
    }

    public SAMLResponse resolve(SAMLRequest request) throws SAMLException {
        SAMLBinding binding = SAMLBindingFactory.getInstance((String)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding");
        return binding.send(this.responder, request);
    }

    public static final SAMLRequest createAuthenticationRequest(Artifact artifact, String assertionIdRef, String authId, String confirmationMethod, String confirmationData, String authMethod) throws SAMLException {
        SAMLSubject subject = new SAMLSubject();
        subject.addConfirmationMethod(confirmationMethod);
        if (artifact == null) {
            SAMLNameIdentifier nameId = new SAMLNameIdentifier();
            nameId.setName(authId);
            subject.setNameIdentifier(nameId);
            Element elm = XML.parserPool.newDocument().createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData");
            elm.setTextContent(confirmationData);
            subject.setConfirmationData(elm);
        }
        SAMLAuthenticationQuery query = new SAMLAuthenticationQuery(subject, authMethod);
        String requestId = SAMLIdentifierFactory.getInstance().getIdentifier();
        SAMLRequest request = new SAMLRequest((SAMLQuery)query, requestId, new Date());
        if (artifact != null) {
            request.addArtifact(artifact);
        } else if (assertionIdRef != null && assertionIdRef.length() > 0) {
            request.addAssertionIdRef(assertionIdRef);
        }
        return request;
    }

    public static final SAMLRequest createAttributeRequest(SAMLAssertion authAssertion, List attributeNames) throws SAMLException {
        SAMLNameIdentifier nameId = new SAMLNameIdentifier();
        nameId.setName(new AssertionParser(authAssertion).getName());
        SAMLSubject subject = new SAMLSubject();
        subject.setNameIdentifier(nameId);
        Document document = XML.parserPool.newDocument();
        Element elm = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData");
        elm.appendChild(authAssertion.toDOM(document));
        subject.setConfirmationData(elm);
        SAMLAttributeQuery query = new SAMLAttributeQuery(subject, null, null);
        int i = 0;
        while (i < attributeNames.size()) {
            query.addDesignator(new SAMLAttributeDesignator(attributeNames.get(i).toString(), "urn:oasis:names:tc:SAML:1.0:assertion"));
            ++i;
        }
        String requestId = SAMLIdentifierFactory.getInstance().getIdentifier();
        SAMLRequest request = new SAMLRequest((SAMLQuery)query, requestId, new Date());
        return request;
    }

    public static final SAMLRequest createAuthorizationDecisionRequest(SAMLAssertion authAssertion, SAMLAssertion attrAssertion, SAMLAction action, String resource) throws SAMLException {
        SAMLNameIdentifier nameId = new SAMLNameIdentifier();
        nameId.setName(new AssertionParser(authAssertion).getName());
        SAMLSubject subject = new SAMLSubject();
        subject.setNameIdentifier(nameId);
        SAMLAuthorizationDecisionQuery query = new SAMLAuthorizationDecisionQuery(subject, resource, null, null);
        query.addAction(action);
        query.addEvidence((Object)authAssertion);
        query.addEvidence((Object)attrAssertion);
        String requestId = SAMLIdentifierFactory.getInstance().getIdentifier();
        SAMLRequest request = new SAMLRequest((SAMLQuery)query, requestId, new Date());
        return request;
    }
}

