/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final byte[] buf = new byte[]{57, 6, 118, -83, 6, 53, -36, 88, -55, -29, 65, -7, 50, 31, 98, 120};
    private static final String defaultCharsetName = "UTF-8";
    private static final String transformation = "AES";

    public static byte[] generateKey() throws NoSuchAlgorithmException, IllegalStateException {
        KeyGenerator keyGen = KeyGenerator.getInstance(transformation);
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        return key.getEncoded();
    }

    public static byte[] encrypt(byte[] source) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return Crypto.encrypt(source, buf);
    }

    public static byte[] encrypt(byte[] source, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (source == null) {
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, transformation);
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, secretKey);
        return cipher.doFinal(source);
    }

    public static String encrypt(String source) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.encrypt(source, defaultCharsetName);
    }

    public static String encrypt(String source, String charsetName) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.encrypt(source, defaultCharsetName, buf);
    }

    public static String encrypt(String source, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.encrypt(source, defaultCharsetName, key);
    }

    public static String encrypt(String source, String charsetName, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (source == null) {
            return null;
        }
        byte[] encrypted = Crypto.encrypt(source.getBytes(charsetName), key);
        return Crypto.toHexString(encrypted);
    }

    public static String decrypt(String encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.decrypt(encrypted, defaultCharsetName);
    }

    public static String decrypt(String encrypted, String charsetName) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.decrypt(encrypted, defaultCharsetName, buf);
    }

    public static String decrypt(String encrypted, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return Crypto.decrypt(encrypted, defaultCharsetName, key);
    }

    public static String decrypt(String encrypted, String charsetName, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (encrypted == null) {
            return null;
        }
        byte[] encByte = Crypto.toByteArray(encrypted);
        byte[] decrypted = Crypto.decrypt(encByte, key);
        return new String(decrypted, charsetName);
    }

    public static byte[] decrypt(byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return Crypto.decrypt(encrypted, buf);
    }

    public static byte[] decrypt(byte[] encrypted, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (encrypted == null) {
            return null;
        }
        SecretKeySpec secretKey = new SecretKeySpec(key, transformation);
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(2, secretKey);
        return cipher.doFinal(encrypted);
    }

    public static String md5(String str) throws NoSuchAlgorithmException {
        return Crypto.hash("MD5", str);
    }

    public static String sha1(String str) throws NoSuchAlgorithmException {
        return Crypto.hash("SHA1", str);
    }

    public static String hash(String algorithm, String str) throws NoSuchAlgorithmException {
        if (str == null) {
            return null;
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(str.getBytes());
        byte[] digest = md.digest();
        return Crypto.toHexString(digest);
    }

    public static final String toHexString(byte[] b) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            String tmp = Integer.toHexString(b[i] & 0xFF);
            if (tmp.length() == 1) {
                buffer.append('0').append(tmp);
            } else {
                buffer.append(tmp);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final byte[] toByteArray(String hex) {
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        while (i < hex.length()) {
            String byteStr = hex.substring(i, i + 2);
            b[i / 2] = new Integer(Integer.parseInt(byteStr, 16)).byteValue();
            i += 2;
        }
        return b;
    }

    /*
     * Unable to fully structure code
     */
    public static final String random(int count) {
        if (count < 1) {
            return "";
        }
        end = 123;
        start = 32;
        buffer = new char[count];
        gap = end - start;
        if (true) ** GOTO lbl28
        do {
            if (Character.isLetter(ch = (char)((random = new Random()).nextInt(gap) + start)) || Character.isDigit(ch)) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count != 0) {
                        buffer[count] = ch;
                        buffer[--count] = (char)(55296 + random.nextInt(128));
                    }
                } else if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                    } else {
                        buffer[count] = (char)(56320 + random.nextInt(128));
                        buffer[--count] = ch;
                    }
                } else if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                } else {
                    buffer[count] = ch;
                }
            } else {
                ++count;
            }
lbl28:
            // 7 sources

            v0 = ++count;
            --count;
        } while (v0 != 0);
        return new String(buffer);
    }
}

