/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.UserService;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserServiceImpl
extends UnicastRemoteObject
implements UserService {
    private static final long serialVersionUID = -6535611897365424355L;

    public UserServiceImpl() throws RemoteException {
    }

    public UserServiceImpl(int port) throws RemoteException {
        super(port);
    }

    public UserServiceImpl(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
    }

    @Override
    public synchronized boolean add(String userName, String relationId) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            if (!lm.isLoggedIn(userName)) {
                lm.add(userName, relationId);
            }
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6206"));
            return true;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6201");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized boolean remove(String userName) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            if (lm.isLoggedIn(userName)) {
                lm.remove(userName);
            }
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6207"));
            return true;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6202");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public boolean removeByRelationId(String relationId) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            lm.removeById(relationId);
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6208"));
            return true;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6203");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized Map<String, String> get() throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            Map<String, String> map = lm.getMap();
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6209"));
            return map;
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6204");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }

    @Override
    public synchronized void set(Map<String, String> users) throws RemoteException {
        try {
            LoginManager lm = LoginManager.getInstance();
            lm.setMap(users);
            Logger.getRootLogger().info((Object)SSOMessageResource.getMessage("6210"));
        }
        catch (Exception e) {
            String message = SSOMessageResource.getMessage("6205");
            Logger.getRootLogger().error((Object)message, (Throwable)e);
            throw new RemoteException(message, e);
        }
    }
}

