/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.sso.servlet;

import info.dragonlady.cluster.UserServiceWrapper;
import info.dragonlady.sso.ArtifactReceiver;
import info.dragonlady.sso.SSOException;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ArtifactReceiverServlet
extends HttpServlet {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            ArtifactReceiver receiver = new ArtifactReceiver(request, response);
            receiver.receive(null);
            String authId = receiver.getAuthId();
            Map attributes = receiver.getAttributes();
            HttpSession session = request.getSession();
            session.setAttribute(SSOServletConfig.getSessionLoginKey(), (Object)authId);
            for (Object key : attributes.keySet()) {
                session.setAttribute((String)key, attributes.get(key));
            }
            LoginManager.getInstance().add(authId, session.getId());
            if (!SSOServletConfig.isClusterStandalone()) {
                UserServiceWrapper.add(authId, session.getId());
            }
            receiver.redirectToTarget();
        }
        catch (SSOException e) {
            this.processException((Exception)((Object)e), response, 403);
        }
        catch (Exception e) {
            this.processException(e, response, 404);
        }
    }

    private void processException(Exception e, HttpServletResponse response, int statusCode) throws ServletException {
        try {
            e.printStackTrace();
            if (!response.isCommitted()) {
                String redirectionUrl = SSOServletConfig.getRedirection();
                if (redirectionUrl != null && redirectionUrl.length() > 0) {
                    response.sendRedirect(redirectionUrl);
                } else {
                    response.sendError(statusCode);
                }
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

