/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.Friend;
import info.dragonlady.cluster.UserService;
import info.dragonlady.cluster.UserServiceException;
import info.dragonlady.sso.helper.LoginManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;

public class UserServiceWrapper {
    public static final void add(String user, String relationId) throws UserServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                String message;
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    service.add(user, relationId);
                }
                catch (ConnectException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (NotBoundException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new UserServiceException(message, e);
        }
    }

    public static final void remove(String user) throws UserServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                String message;
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    service.remove(user);
                }
                catch (ConnectException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (NotBoundException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new UserServiceException(message, e);
        }
    }

    public static final void removeByRelationId(String relationId) throws UserServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                String message;
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "UserService");
                    UserService service = (UserService)Naming.lookup(name);
                    service.removeByRelationId(relationId);
                }
                catch (ConnectException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (NotBoundException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new UserServiceException(message, e);
        }
    }

    public static final void synchronize() throws UserServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                block7: {
                    String message;
                    Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                    try {
                        String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "UserService");
                        UserService service = (UserService)Naming.lookup(name);
                        Map map = service.get();
                        if (map == null) break block7;
                        LoginManager lm = LoginManager.getInstance();
                        lm.setMap(map);
                        break;
                    }
                    catch (ConnectException e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                    catch (NotBoundException e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new UserServiceException(message, e);
        }
    }
}

