/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.cluster;

import info.dragonlady.cluster.AssertionService;
import info.dragonlady.cluster.AssertionServiceException;
import info.dragonlady.cluster.Friend;
import info.dragonlady.sso.AssertionManager;
import info.dragonlady.sso.helper.SSOServletConfig;
import info.dragonlady.sso.message.SSOMessageResource;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.Map;
import org.opensaml.SAMLAssertion;

public class AssertionServiceWrapper {
    public static final void put(String id, SAMLAssertion assertion) throws AssertionServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                String message;
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "AssertionService");
                    AssertionService service = (AssertionService)Naming.lookup(name);
                    String handleStr = (String)AssertionManager.getInstance().getHandleMap().get(id);
                    service.put(id, handleStr, assertion.toString());
                }
                catch (ConnectException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (NotBoundException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new AssertionServiceException(message, e);
        }
    }

    public static final void remove(String id) throws AssertionServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                String message;
                Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                try {
                    String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "AssertionService");
                    AssertionService service = (AssertionService)Naming.lookup(name);
                    service.removeById(id);
                }
                catch (ConnectException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (NotBoundException e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                catch (Exception e) {
                    message = SSOMessageResource.getMessage((String)"", (Object[])args);
                    System.out.println(message);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new AssertionServiceException(message, e);
        }
    }

    public static final void synchronize() throws AssertionServiceException {
        try {
            Friend[] friends = SSOServletConfig.getFriends();
            int i = 0;
            while (i < friends.length) {
                block7: {
                    String message;
                    Object[] args = new String[]{friends[i].getHost(), friends[i].getPort()};
                    try {
                        String name = SSOServletConfig.getServiceName(args[0], (String)args[1], "AssertionService");
                        AssertionService service = (AssertionService)Naming.lookup(name);
                        Map handleMap = service.getHandleMap();
                        Map assertionMap = service.getAssertionMap();
                        if (handleMap == null || assertionMap == null) break block7;
                        AssertionManager.getInstance().setHandleMap(handleMap);
                        AssertionManager.getInstance().setAssertionMap(assertionMap);
                        break;
                    }
                    catch (ConnectException e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                    catch (NotBoundException e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        message = SSOMessageResource.getMessage((String)"", (Object[])args);
                        System.out.println(message);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = SSOMessageResource.getMessage((String)"");
            throw new AssertionServiceException(message, e);
        }
    }
}

