/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.integration.ant.container.resin;

import java.io.File;
import java.net.URL;
import org.apache.cactus.integration.ant.container.ContainerRunner;
import org.apache.cactus.integration.ant.container.resin.AbstractResinContainer;
import org.apache.cactus.integration.ant.deployment.EarParser;
import org.apache.cactus.integration.ant.deployment.WarParser;
import org.apache.cactus.integration.ant.util.DefaultAntTaskFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public abstract class AbstractResinTask
extends Task {
    private File dir;
    private String action;
    private File earFile;
    private File warFile;
    private URL testURL;
    private File resinConf;
    private int port = 8080;
    private File tmpDir;
    private File output;
    private boolean append;
    private Path containerClasspath;

    public final void setDir(File theDir) {
        this.dir = theDir;
    }

    public void setAction(String theAction) {
        this.action = theAction;
    }

    public final void setWarFile(File theWarFile) {
        if (this.getEarFile() != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.warFile = theWarFile;
    }

    public final void setEarFile(File theEarFile) {
        if (this.getWarFile() != null) {
            throw new BuildException("You may only specify one of [earfile] and [warfile]");
        }
        this.earFile = theEarFile;
    }

    public void setTestURL(URL theTestURL) {
        this.testURL = theTestURL;
    }

    public final void setTmpDir(File theTmpDir) {
        this.tmpDir = theTmpDir;
    }

    public final void setResinConf(File theResinConf) {
        this.resinConf = theResinConf;
    }

    public final void setPort(int thePort) {
        this.port = thePort;
    }

    public final void setOutput(File theOutput) {
        this.output = theOutput;
    }

    public final void setAppend(boolean isAppend) {
        this.append = isAppend;
    }

    private void verify(AbstractResinContainer theContainer) {
        theContainer.verify();
        if (this.getAction() == null) {
            throw new BuildException("You must specify an [action] attribute");
        }
        if (!this.getAction().equalsIgnoreCase("start") && !this.getAction().equalsIgnoreCase("stop")) {
            throw new BuildException("Valid actions are: [start] and [stop]");
        }
    }

    protected abstract AbstractResinContainer getResinContainer();

    public void execute() {
        AbstractResinContainer container = this.getResinContainer();
        if (this.getWarFile() != null) {
            container.setDeployableFile(WarParser.parse(this.getWarFile()));
        } else if (this.getEarFile() != null) {
            container.setDeployableFile(EarParser.parse(this.getEarFile()));
        }
        container.setDir(this.getDir());
        container.setAntTaskFactory(new DefaultAntTaskFactory(this.getProject(), this.getTaskName(), this.getLocation(), this.getOwningTarget()));
        container.setPort(this.getPort());
        container.setContainerClasspath(this.containerClasspath);
        if (this.getResinConf() != null) {
            container.setResinConf(this.getResinConf());
        }
        if (this.getTmpDir() != null) {
            container.setTmpDir(this.getTmpDir());
        }
        if (this.getOutput() != null) {
            container.setOutput(this.getOutput());
        }
        if (this.getAppend()) {
            container.setAppend(this.getAppend());
        }
        this.verify(container);
        ContainerRunner runner = null;
        if (this.getTestURL() != null) {
            runner = new ContainerRunner(container);
            runner.setURL(this.getTestURL());
        }
        if (this.getAction().equalsIgnoreCase("start")) {
            if (this.getTestURL() != null) {
                runner.startUpContainer();
            } else {
                container.startUp();
            }
        } else if (this.getAction().equalsIgnoreCase("stop")) {
            if (this.getTestURL() != null) {
                runner.shutDownContainer();
            } else {
                container.shutDown();
            }
        }
    }

    protected final String getAction() {
        return this.action;
    }

    protected final File getDir() {
        return this.dir;
    }

    protected final URL getTestURL() {
        return this.testURL;
    }

    protected final int getPort() {
        return this.port;
    }

    protected final File getResinConf() {
        return this.resinConf;
    }

    protected final File getWarFile() {
        return this.warFile;
    }

    protected final File getEarFile() {
        return this.earFile;
    }

    protected final File getTmpDir() {
        return this.tmpDir;
    }

    protected final File getOutput() {
        return this.output;
    }

    protected final boolean getAppend() {
        return this.append;
    }

    public Path createContainerClasspath() {
        if (this.containerClasspath == null) {
            this.containerClasspath = new Path(this.project);
        }
        return this.containerClasspath.createPath();
    }
}

